% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnpathplot.R
\name{bnpathplot}
\alias{bnpathplot}
\title{bnpathplot}
\usage{
bnpathplot(
  results,
  exp,
  expSample = NULL,
  algo = "hc",
  algorithm.args = NULL,
  expRow = "ENSEMBL",
  cl = NULL,
  returnNet = FALSE,
  otherVar = NULL,
  otherVarName = NULL,
  qvalueCutOff = NULL,
  adjpCutOff = 0.05,
  nCategory = 15,
  R = 20,
  interactive = FALSE,
  color = "p.adjust",
  cexCategory = 1,
  cexLine = 0.5,
  chooseDir = FALSE,
  showDir = FALSE,
  delZeroDegree = TRUE,
  labelSize = 4,
  layout = "nicely",
  onlyDf = FALSE,
  disc = FALSE,
  tr = NULL,
  remainCont = NULL,
  shadowText = TRUE,
  bgColor = "white",
  textColor = "black",
  compareRef = FALSE,
  strThresh = NULL,
  strType = "normal",
  hub = NULL,
  scoreType = "bic-g",
  databasePal = "Set2",
  dep = NULL,
  sizeDep = FALSE,
  orgDb = org.Hs.eg.db,
  bypassConverting = FALSE,
  useSiGN = FALSE,
  edgeLink = TRUE,
  cellLineName = "5637_URINARY_TRACT",
  strengthPlot = FALSE,
  nStrength = 10,
  seed = 1
)
}
\arguments{
\item{results}{the enrichment analysis result}

\item{exp}{gene expression matrix}

\item{expSample}{candidate rows to be included in the inference
default to all}

\item{algo}{structure learning method used in boot.strength()
default to "hc"}

\item{algorithm.args}{parameters to pass to 
bnlearn structure learnng function}

\item{expRow}{the type of the identifier of rows of expression matrix}

\item{cl}{cluster object from parallel::makeCluster()}

\item{returnNet}{whether to return the network}

\item{otherVar}{other variables to be included in the inference}

\item{otherVarName}{the names of other variables}

\item{qvalueCutOff}{the cutoff value for qvalue}

\item{adjpCutOff}{the cutoff value for adjusted pvalues}

\item{nCategory}{the number of pathways to be included}

\item{R}{the number of bootstrap}

\item{interactive}{whether to use bnviewer (default to FALSE)}

\item{color}{color of node, default to adjusted p-value}

\item{cexCategory}{scaling factor of size of nodes}

\item{cexLine}{scaling factor of width of edges}

\item{chooseDir}{if undirected edges are present, choose direction of edges}

\item{showDir}{show the confidence of direction of edges}

\item{delZeroDegree}{delete zero degree nodes}

\item{labelSize}{the size of label of the nodes}

\item{layout}{ggraph layout, default to "nicely"}

\item{onlyDf}{return only data.frame used for inference}

\item{disc}{discretize the expressoin data}

\item{tr}{Specify data.frame if one needs to discretize
as the same parameters as the other dataset}

\item{remainCont}{Specify characters when perform discretization,
if some columns are to be remain continuous}

\item{shadowText}{whether to use shadow text for the better readability
(default: TRUE)}

\item{bgColor}{color for text background when shadowText is TRUE}

\item{textColor}{color for text when shadowText is TRUE}

\item{compareRef}{whether compare to the reference network between pathway}

\item{strThresh}{threshold for strength, automatically determined if NULL}

\item{strType}{"normal" or "ms" for multiscale implementation}

\item{hub}{change the shape of node according to hub scores (default NULL)}

\item{scoreType}{score type to use on choosing edge direction}

\item{databasePal}{palette to be used in scale_color_brewer
when the multiple results are to be shown}

\item{dep}{the tibble storing dependency score from library depmap}

\item{sizeDep}{whether to reflect DepMap score to the node size}

\item{orgDb}{perform clusterProfiler::setReadable based on
this organism database}

\item{bypassConverting}{bypass the symbol converting
If you use custom annotation databases that 
does not have SYMBOL listed in keys.
ID of rownames and those listed in EA result
must be same.}

\item{useSiGN}{default to FALSE.
For using SiGN-BN in the function in Windows 10/11,
1. Download the SiGN-BN HC+BS binary in WSL
(https://sign.hgc.jp/signbn/download.html)
2. Set PATH to executable (sign.1.8.3)}

\item{edgeLink}{whether to set edge to geom_edge_link()
FALSE to use geom_edge_diagonal()}

\item{cellLineName}{the cell line name to be included}

\item{strengthPlot}{append the barplot depicting edges with high strength}

\item{nStrength}{specify how many edges are included in the strength plot}

\item{seed}{A random seed to make the analysis reproducible, default is 1.}
}
\value{
ggplot2 object
}
\description{
Plot pathway relationship
}
\examples{
data("exampleEaRes");data("exampleGeneExp")
res <- bnpathplot(results = exampleEaRes, exp = exampleGeneExp,
                  R = 10, expRow = "ENSEMBL")

}
