% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDR.R
\name{plotDR}
\alias{plotDR}
\title{Plot reduced dimensions}
\usage{
plotDR(
  x,
  dr = NULL,
  color_by = "condition",
  facet_by = NULL,
  ncol = NULL,
  assay = "exprs",
  scale = TRUE,
  q = 0.01,
  dims = c(1, 2),
  k_pal = .cluster_cols,
  a_pal = hcl.colors(10, "Viridis")
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{dr}{character string specifying which dimension reduction to use. 
Should be one of \code{reducedDimNames(x)}; default to the 1st available.}

\item{color_by}{character string specifying the color coding;
valid values are \code{rownames(sce)} and \code{names(colData(x))}.}

\item{facet_by}{character string specifying a
non-numeric cell metadata column to facet by; 
valid values are \code{names(colData(x))}.}

\item{ncol}{integer scalar specifying number of facet columns; 
ignored unless coloring by multiple features without facetting
or coloring by a single feature with facetting.}

\item{assay}{character string specifying which assay data to use
when coloring by marker(s); valid values are \code{assayNames(x)}.}

\item{scale}{logical specifying whether \code{assay} data should be scaled
between 0 and 1 using lower (1\%) and upper (99\%) expression quantiles;
ignored if \code{!all(color_by \%in\% rownames(x))}.}

\item{q}{single numeric in [0,0.5) determining the 
quantiles to trim when \code{scale = TRUE}.}

\item{dims}{length 2 numeric specifying which dimensions to plot.}

\item{k_pal}{character string specifying the cluster color palette; 
ignored when \code{color_by} is not one of \code{names(cluster_codes(x))}. 
If less than \code{nlevels(cluster_ids(x, k))} are supplied, colors will 
be interpolated via \code{\link[grDevices:colorRamp]{colorRampPalette}}.}

\item{a_pal}{character string specifying the \code{assay} data palette 
when coloring by feature(s), i.e. \code{all(color_by \%in\% rownames(x))}.}
}
\value{
a \code{ggplot} object.
}
\description{
Dimension reduction plot colored 
by expression, cluster, sample or group ID.
}
\examples{
# construct SCE & run clustering
data(PBMC_fs, PBMC_panel, PBMC_md)
sce <- prepData(PBMC_fs, PBMC_panel, PBMC_md)

# run clustering & dimension reduction
sce <- cluster(sce)
sce <- runDR(sce, dr = "UMAP", cells = 100)

# color by single marker, split by sample
plotDR(sce, color_by = "CD7", facet_by = "sample_id", ncol = 4)

# color by a set of markers using custom color palette
cdx <- grep("CD", rownames(sce), value = TRUE)
plotDR(sce, color_by = cdx, ncol = 4, 
  a_pal = rev(hcl.colors(10, "Spectral")))

# color by scaled expression for 
# set of markers, split by condition
plotDR(sce, 
  scale = TRUE, 
  facet_by = "condition",
  color_by = sample(rownames(sce), 4))

# color by 8 metaclusters using custom 
# cluster color palette, split by sample
p <- plotDR(sce, 
  color_by = "meta8", 
  facet_by = "sample_id", 
  k_pal = c("lightgrey", "cornflowerblue", "navy")) 
p$facet$params$ncol <- 4; p

}
\references{
Nowicka M, Krieg C, Crowell HL, Weber LM et al. 
CyTOF workflow: Differential discovery in 
high-throughput high-dimensional cytometry datasets.
\emph{F1000Research} 2017, 6:748 (doi: 10.12688/f1000research.11622.1)
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
