% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARD.imputation.R
\name{mvn_cv}
\alias{mvn_cv}
\title{Imputation and Construction of High-Resolution Spatial Maps for Cell Type
Composition and Gene Expression by the spatial correlation structure between
original spatial locations and new grided spatial locations}
\usage{
mvn_cv(
  vtrain,
  location_orig,
  train_ind,
  test_ind,
  B,
  xinput_norm,
  optimal_b,
  optimal_phi,
  lambda,
  ineibor
)
}
\arguments{
\item{vtrain}{Matrix, estimated V matrix from CARD}

\item{location_orig}{Data frame, spatial location data frame of the original
spatial resolved transcriptomics dataset, stored in the
spatialCoords(CARD_object)}

\item{train_ind}{Vector, index of the original spatial locations}

\item{test_ind}{Vector, index of the newly grided spatial locations}

\item{B}{Matrix, used in the deconvolution as the reference basis matrix}

\item{xinput_norm}{Matrix, used in the deconvolution as the normalized
spatial count data}

\item{optimal_b}{Vector, vector of the intercept for each cel type estimated
based on the original spatial resolution}

\item{optimal_phi}{Numeric, the optimal phi value stored in CARD_object}

\item{lambda}{Vector, vector of cell type specific scalar in the CAR model}

\item{ineibor}{Numeric, number of neighbors used in the imputation on newly
grided spatial locations, default is 10.}
}
\value{
Return a list with the imputed Cell type composition Vtest matrix on
the newly grided spatial locations and predicted normalized gene expression
}
\description{
Imputation and Construction of High-Resolution Spatial Maps for Cell Type
Composition and Gene Expression by the spatial correlation structure between
original spatial locations and new grided spatial locations
}
