% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{CARD_visualize_prop_2CT}
\alias{CARD_visualize_prop_2CT}
\title{Visualize the spatial distribution of two cell type proportions on
the same plot}
\usage{
CARD_visualize_prop_2CT(
  proportion,
  spatial_location,
  ct2_visualize = ct2_visualize,
  colors = NULL
)
}
\arguments{
\item{proportion}{Data frame, cell type proportion estimated by CARD in
either original resolution or enhanced resolution.}

\item{spatial_location}{Data frame, spatial location information.}

\item{ct2_visualize}{Vector of selected two cell type names that are
interested to visualize, here we only focus on two cell types}

\item{colors}{list of color names that you want to use for each cell type,
if NULL, we will use the default color scale list
list(c("lightblue","lightyellow","red"),c("lightblue","lightyellow","black")}
}
\value{
Returns a ggplot2 figure.
}
\description{
Visualize the spatial distribution of two cell type proportions on
the same plot
}
\examples{
library(ggplot2)
library(SpatialExperiment)
data(spatial_count)
data(spatial_location)
data(sc_count)
data(sc_meta)
CARD_obj <- CARD_deconvolution(
    sc_count = sc_count,
    sc_meta = sc_meta,
    spatial_count = spatial_count,
    spatial_location = spatial_location,
    ct_varname = "cellType",
    ct_select = unique(sc_meta$cellType),
    sample_varname = "sampleInfo",
    mincountgene = 100,
    mincountspot = 5
)
CARD_visualize_prop_2CT(
    proportion = CARD_obj$Proportion_CARD,
    spatial_location = spatialCoords(CARD_obj),
    ct2_visualize = c("Cancer_clone_A", "Cancer_clone_B"),
    colors = list(c("lightblue", "lightyellow", "red"), c(
        "lightblue", "lightyellow",
        "black"
    ))
)

}
