% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARD.refFree.R
\name{CARD_refFree}
\alias{CARD_refFree}
\title{Extension of CARD into a reference-free version of
deconvolution: CARDfree.}
\usage{
CARD_refFree(
  markerlist,
  spatial_count,
  spatial_location,
  mincountgene = 100,
  mincountspot = 5,
  spe = NULL
)
}
\arguments{
\item{markerlist}{a list of marker genes, with each element of the list
being the vector of cell type specific marker genes}

\item{spatial_count}{Raw spatial resolved transcriptomics data, each column
is a spatial location, and each row is a gene.}

\item{spatial_location}{data frame, with two columns representing the x and
y coordinates of the spatial location. The rownames of this data frame
should match eaxctly with the columns of the spatial_count.}

\item{mincountgene}{Minimum counts for each gene}

\item{mincountspot}{Minimum counts for each spatial location}

\item{spe}{a \code{SpatialExperiment} object containing spatial data in
the \code{counts} assay, and spatial coordinates in the spatialCoords.}
}
\value{
Returns a SpatialExperiment object with estimated cell type
proportion stored in object$Proportion_CARD. Because this is a
reference-free version, the columns of estimated proportion is not cell
type but cell type cluster
}
\description{
Extension of CARD into a reference-free version of
deconvolution: CARDfree.
}
\examples{
library(RcppML)
library(NMF)
library(RcppArmadillo)
data(markerList)
data(spatial_count)
data(spatial_location)
CARDfree_obj <- CARD_refFree(
markerlist = markerList[8:16],
spatial_count = spatial_count[1:2500, ],
spatial_location = spatial_location,
mincountgene = 100,
mincountspot = 5
)

}
