% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compoundQuantiles.R
\docType{methods}
\name{getIsotopeProportion,compoundQuantiles-method}
\alias{getIsotopeProportion}
\alias{getIsotopeProportion,compoundQuantiles-method}
\title{The proportion of the intensities of two isotope peaks}
\usage{
\S4method{getIsotopeProportion}{compoundQuantiles}(object, isotope1, isotope2,
  mass, quantile)
}
\arguments{
\item{object}{A compoundQuantiles object}

\item{isotope1}{The divident isotope ranging from 0 (the monoisotopic peak) to 5}

\item{isotope2}{The divisor isotope ranging from 0 (the monoisotopic peak) to 5}

\item{mass}{The mass of the compound specified in atomic units (=dalton)}

\item{quantile}{The quantile level for the isotope proportion}
}
\value{
The isotope proportion
}
\description{
Returns the proportion of the intensities of isotope1 versus isotope2 for a compound of the given mass for the given quantile level
}
\examples{
cpObj <- compoundQuantiles(compoundLibrary = "kegg")

compoundMass <- 503
isotope1 <- 0
isotope2 <- 1
quantileLow   <- 0.05
quantileHigh  <- 0.95

propLow  <- getIsotopeProportion(object = cpObj, isotope1 = isotope1, isotope2 = isotope2, mass = compoundMass, quantile = quantileLow)
propHigh <- getIsotopeProportion(object = cpObj, isotope1 = isotope1, isotope2 = isotope2, mass = compoundMass, quantile = quantileHigh)
print(paste("The ", (quantileHigh - quantileLow) * 100, "\% confidence interval for the proportion of isotopes ", isotope1, " / ", isotope2, " in a compound with mass ", compoundMass, " is [", propLow, ", ", propHigh, "]", sep = ""))
}
\author{
Hendrik Treutler
}

