% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportMethods.R
\name{plotInterquantileWidth}
\alias{plotInterquantileWidth}
\alias{plotInterquantileWidth,CAGEexp-method}
\title{Plot cluster widths}
\usage{
plotInterquantileWidth(
  object,
  clusters = c("tagClusters", "consensusClusters"),
  tpmThreshold = 5,
  qLow = 0.1,
  qUp = 0.9,
  xlim = c(0, 150)
)

\S4method{plotInterquantileWidth}{CAGEexp}(
  object,
  clusters = c("tagClusters", "consensusClusters"),
  tpmThreshold = 5,
  qLow = 0.1,
  qUp = 0.9,
  xlim = c(0, 150)
)
}
\arguments{
\item{object}{A \code{\link{CAGEexp}} object}

\item{clusters}{\code{tagClusters} or \code{consensusClusters}.}

\item{tpmThreshold}{Exclude clusters with normalized signal lower than \code{tpmThreshold}.}

\item{qLow, qUp}{Quantile defining the 5' ("lower") and 3' ("upper")
boundaries of the clusters.}

\item{xlim}{Range of width to be plotted.}
}
\value{
Plots the histograms with the \code{ggplot2} engine and returns the plot
object invisibly.
}
\description{
Histograms of the interquantile width of tag clusters or
consensus clusters in each CAGE experiment.
}
\details{
Interquantile width is a more robust measure of the promoter width
than the total span of the region, because it takes into account the
magnitude of the expression in the region.  Positions of specified quantiles
within each cluster have to be calculated beforehand by calling
\code{\link{quantilePositions}}.
}
\examples{

plotInterquantileWidth( exampleCAGEexp, clusters = "tagClusters"
                      , tpmThreshold = 50, qLow = 0.1, qUp = 0.9
                      , xlim = c(2,200))
                      
plotInterquantileWidth( exampleCAGEexp, clusters = "consensusClusters"
                      , tpmThreshold = 50, qLow = 0.1, qUp = 0.9
                      , xlim = c(2,200))

}
\seealso{
Other CAGEr plot functions: 
\code{\link{TSSlogo}()},
\code{\link{hanabiPlot}()},
\code{\link{plotAnnot}()},
\code{\link{plotCorrelation}()},
\code{\link{plotExpressionProfiles}()},
\code{\link{plotReverseCumulatives}()}

Other CAGEr clusters functions: 
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CustomConsensusClusters}()},
\code{\link{aggregateTagClusters}()},
\code{\link{consensusClustersDESeq2}()},
\code{\link{consensusClustersGR}()},
\code{\link{cumulativeCTSSdistribution}()},
\code{\link{distclu}()},
\code{\link{paraclu}()},
\code{\link{quantilePositions}()},
\code{\link{tagClustersGR}()}
}
\author{
Vanja Haberle

Charles Plessy
}
\concept{CAGEr clusters functions}
\concept{CAGEr plot functions}
