% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImportMethods.R
\name{import.bigwig}
\alias{import.bigwig}
\title{Read in BigWig files to CAGEexp object}
\usage{
import.bigwig(filepath)
}
\arguments{
\item{filepath}{Path to an input bigwig file on the plus strand.}
}
\value{
a CAGEexp object
}
\description{
Read in BigWig files to CAGEexp object
}
\note{
The filename must contain the string \code{str1} and have a pair for the
minus strand that has identical path except with the \code{str2} substring, so
that \code{inputFiles} CAGEexp object will only point to plus-strand BigWig files.
}
\examples{

pathsToInputFiles <- list.files( system.file("extdata", package = "CAGEr")
                               , "str1.out.wig.bw$" , full.names = TRUE)
                               
CAGEr:::import.bigwig(pathsToInputFiles[1])

\dontrun{
sampleLabels <- sub( "_subsampled_str1.Signal.Unique.str1.out.wig.bw"
                   , "", basename(pathsToInputFiles))
CAGEexp( genomeName     = "BSgenome.Drerio.UCSC.danRer7"
       , inputFiles     = pathsToInputFiles
       , inputFilesType = "bigwig"
       , sampleLabels   = sampleLabels) |> getCTSS()
}
}
\seealso{
Other loadFileIntoGPos: 
\code{\link{bam2CTSS}()},
\code{\link{import.CTSS}()},
\code{\link{import.bam}()},
\code{\link{import.bam.ctss}()},
\code{\link{import.bedCTSS}()},
\code{\link{import.bedScore}()},
\code{\link{import.bedmolecule}()},
\code{\link{loadFileIntoGPos}()},
\code{\link{moleculesGR2CTSS}()}
}
\author{
Katalin Ferenc

Damir Baranasic
}
\concept{loadFileIntoGPos}
