% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMethods.R
\name{expressionClasses}
\alias{expressionClasses}
\alias{expressionClasses,CTSS-method}
\alias{expressionClasses,ConsensusClusters-method}
\title{Extract labels of \emph{expression classes}}
\usage{
expressionClasses(object)

\S4method{expressionClasses}{CTSS}(object)

\S4method{expressionClasses}{ConsensusClusters}(object)
}
\arguments{
\item{object}{A \code{\link{CAGEr}} object.}
}
\value{
Returns a \code{\link[S4Vectors:Rle-class]{S4Vectors::Rle}}-encoded vector of labels of \emph{expression classes}.
The number of labels matches the number of expression clusters returned by
\code{\link{getExpressionProfiles}} function.
}
\description{
Retrieves labels of \emph{expression classes} of individual CTSSs
or consensus clusters from a \code{CAGEr} object.
}
\examples{
expressionClasses(CTSScoordinatesGR(exampleCAGEexp))
exampleCAGEexp |> consensusClustersGR() |> expressionClasses()

}
\seealso{
Other CAGEr expression clustering functions: 
\code{\link{getExpressionProfiles}()},
\code{\link{plotExpressionProfiles}()}

Other CAGEr accessor methods: 
\code{\link{CTSScoordinatesGR}()},
\code{\link{CTSScumulativesTagClusters}()},
\code{\link{CTSSnormalizedTpmDF}()},
\code{\link{CTSStagCountDF}()},
\code{\link{GeneExpDESeq2}()},
\code{\link{GeneExpSE}()},
\code{\link{consensusClustersGR}()},
\code{\link{filteredCTSSidx}()},
\code{\link{genomeName}()},
\code{\link{inputFiles}()},
\code{\link{inputFilesType}()},
\code{\link{librarySizes}()},
\code{\link{sampleLabels}()},
\code{\link{seqNameTotalsSE}()},
\code{\link{tagClustersGR}()}
}
\concept{CAGEr accessor methods}
\concept{CAGEr expression clustering functions}
