% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusteringMethods.R
\name{.byCtss}
\alias{.byCtss}
\alias{.byCtss,data.table-method}
\title{Apply functions to identical CTSSes.}
\usage{
.byCtss(ctssDT, colName, fun)

\S4method{.byCtss}{data.table}(ctssDT, colName, fun)
}
\arguments{
\item{ctssDT}{A \code{\link[data.table:data.table]{data.table::data.table}} representing CTSSes.}

\item{colName}{The name of the column on which to apply the function.}

\item{fun}{The function to apply.}
}
\description{
\code{.byCTSS} is a private function using  \code{data.table} objects
to preform grouping operations at a high performance.  These functions use
\emph{non-standard evaluation} in a context that raises warnings in \verb{R CMD check}.
By separating these functions from the rest of the code, I hope to make the workarounds
easier to manage.
}
\examples{
ctssDT <- data.table::data.table(
  chr       = c("chr1", "chr1", "chr1", "chr2"),
  pos       = c(1     , 1     , 2     , 1     ),
  strand    = c("+"   , "+"   , "-"   , "-"   ),
  tag_count = c(1     , 1     , 1     , 1     ))
ctssDT
CAGEr:::.byCtss(ctssDT, "tag_count", sum)
}
