% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{spatialDiversityPlot}
\alias{spatialDiversityPlot}
\title{2D-projection of spatial score distributions}
\usage{
spatialDiversityPlot(
  scores,
  associations,
  proj = c("PCA", "tSNE"),
  score.based = FALSE,
  qval.thres = 0.01,
  val.thres = 0,
  with.names = FALSE,
  text.fs = 2.5,
  legend.fs = 10,
  axis.fs = 10,
  label.fs = 12,
  dot.size = 1,
  perplexity = 10
)
}
\arguments{
\item{scores}{A matrix of scores, one L-R interaction per row and
spatial locations in the columns. This matrix is typically obtained
from BulkSignalR functions \code{scoreLRGeneSignatures} or \code{scScoring}.}

\item{associations}{A statistical association data.frame generated
by the function \code{spatialAssociation}.}

\item{proj}{Projection method : 'PCA' or 'tSNE' are available arguements.}

\item{score.based}{A logical indicating whether the plot should be
based on scores or the associations directly.}

\item{qval.thres}{The maximum Q-value to consider in the plot (a
L-R interaction must associate with one label at least with a Q-value
smaller or equal to this threshold). Relevant for Kruskal-Wallis and
ANOVA tests in \code{spatialAssociation}.}

\item{val.thres}{The minimum value to consider in the plot (a
L-R interaction must associate with one label at least with a value
larger or equal to this threshold). Relevant for Spearman and r2
associations in \code{spatialAssociation}.}

\item{with.names}{A logical indicating whether L-R names should be plotted.}

\item{text.fs}{Point label font size in case \code{with.names} is TRUE.}

\item{legend.fs}{Legend items font size.}

\item{axis.fs}{Axis ticks font size.}

\item{label.fs}{Legend titles and axis names font size.}

\item{dot.size}{Dot size.}

\item{perplexity}{Perplexity parameter for t-SNE.}
}
\value{
Display a 2D-projection of the score spatial distributions.
}
\description{
Use PCA or t-SNE to obtain a 2D-projection of a set of spatial scores
or associations.
This plot summarizes the diversity of patterns occuring in a spatial
dataset. Use the function \code{spatialIndexPlot} to create a large
visual index of many spatial distributions.
Not limited to BulkSignalR gene signature scores.
}
\details{
Display a 2D-projection of the score spatial distributions.
}
\examples{
data(bsrdm.spa, package = "BulkSignalR")
data(bsrinf.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")

thres <- 0.01
bsrinf.red <- reduceToBestPathway(bsrinf.spa)
s.red  <- BSRSignature(bsrinf.red, qval.thres=thres)
scores.red <- scoreLRGeneSignatures(bsrdm.spa,s.red)

# statistical association with tissue areas based on correlations
# For display purpose, we only use a subset here


assoc.bsr.corr <- spatialAssociation(scores.red[c(1:3), ],
annotation.spa, label.col = "ground_truth",test = "Spearman")

spatialDiversityPlot(scores.red[c(1:3),],assoc.bsr.corr)

}
