% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRDataModel-class.R,
%   R/BSRDataModelComp-class.R
\name{scoreLRGeneSignatures}
\alias{scoreLRGeneSignatures}
\alias{scoreLRGeneSignatures,BSRDataModel-method}
\alias{scoreLRGeneSignatures,BSRDataModelComp-method}
\title{Score ligand-receptor gene signatures}
\usage{
\S4method{scoreLRGeneSignatures}{BSRDataModel}(
  obj,
  sig,
  LR.weight = 0.5,
  robust = FALSE,
  name.by.pathway = FALSE,
  abs.z.score = FALSE,
  rownames.LRP = FALSE
)

\S4method{scoreLRGeneSignatures}{BSRDataModelComp}(
  obj,
  sig,
  LR.weight = 0.5,
  robust = FALSE,
  name.by.pathway = FALSE,
  abs.z.score = FALSE,
  rownames.LRP = FALSE
)
}
\arguments{
\item{obj}{A BSRDataModelComp object.}

\item{sig}{A BSRSignatureComp object.}

\item{LR.weight}{A number between 0 and 1 defining the relative weight
of the ligand and the receptor in the signature.}

\item{robust}{A logical indicating that z-scores should be computed
with median and MAD instead of mean and standard deviation.}

\item{name.by.pathway}{A logical indicating whether row names of the
resulting score matrix should be pathway names.}

\item{abs.z.score}{A logical to use absolute z-scores (useful if the
activity of a paythway is reported by a mixture of up- and down-genes
whose z-score averages might hide actual activity).}

\item{rownames.LRP}{A logical indicating, in case \code{name.by.pathway}
was set to TRUE, whether ligand and receptor names should be added on top.
No role if \code{name.by.pathway} was set to FALSE.}
}
\value{
A matrix containing the scores of each ligand-receptor gene
signature in each sample.

A matrix containing the scores of each ligand-receptor gene
signature in each sample.
}
\description{
Compute ligand-receptor gene signature scores over a BSRDataModel.

Compute ligand-receptor gene signature scores over a BSRDataModelComp
specific comparison.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")

bsrinf.redBP <- reduceToBestPathway(bsrinf)
bsrsig.redBP <- BSRSignature(bsrinf.redBP, qval.thres = 0.001)
res <-scoreLRGeneSignatures(bsrdm, bsrsig.redBP,
    name.by.pathway = FALSE
)
# prepare data
data(bsrdm.comp, package = "BulkSignalR")
data(bsrinf.comp, package = "BulkSignalR")

# reduction
bsrinf.red <- reduceToBestPathway(bsrinf.comp)
# signature extraction and scoring
bsrsig.red <- BSRSignatureComp(bsrinf.red, qval.thres = 1e-6)
scores.red <- scoreLRGeneSignatures(bsrdm.comp, bsrsig.red,
    name.by.pathway = TRUE, rownames.LRP = TRUE
)
}
