% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellTypeAssign.R
\name{relateToGeneSet}
\alias{relateToGeneSet}
\title{Relate ligands to a gene set}
\usage{
relateToGeneSet(bsrinf, gs, min.cor = 0.25, qval.thres = 0.001)
}
\arguments{
\item{bsrinf}{BSRInference object.}

\item{gs}{The gene set.}

\item{min.cor}{Minimum Spearman correlation between the receptor of a triple
(L,R,pw) and a gene of the gene set.}

\item{qval.thres}{Maximum Q-value imposed to the (L,R,pw) triples to be
considered.}
}
\value{
A data.frame listing all the (L,R,pathway) triples that lead
to at least one gene in the gene set. The number of genes found
by each triple is indicated in the column \code{n.genes}.
}
\description{
Finds ligands related to a gene set by following receptor, and
receptor downstream pathway targets.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")

data(p.EMT, package = "BulkSignalR")
p.EMT <- p.EMT$gene
triggers <- relateToGeneSet(bsrinf, p.EMT) 
}
