% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInference-class.R,
%   R/BSRInferenceComp-class.R
\name{reduceToBestPathway}
\alias{reduceToBestPathway}
\alias{reduceToBestPathway,BSRInference-method}
\alias{reduceToBestPathway,BSRInferenceComp-method}
\title{Keep one pathway per ligand-receptor pair}
\usage{
\S4method{reduceToBestPathway}{BSRInference}(obj)

\S4method{reduceToBestPathway}{BSRInferenceComp}(obj)
}
\arguments{
\item{obj}{BSRInferenceComp object}
}
\value{
A BSRInference object reduced to only report one pathway per
ligand-receptor pair. The pathway with the
smallest P-value is selected.

A BSRInferenceComp object reduced to only report one pathway per
ligand-receptor pair. The pathway with the
smallest P-value is selected.
}
\description{
Keep one pathway per ligand-receptor pair

Keep one pathway per ligand-receptor pair
}
\details{
Ligand-receptor pairs
are evaluated in relation with pathways that allow checking receptor
downstream correlations. It is thus possible
that several pathways are reported for a same LR pair.

Ligand-receptor pairs
are evaluated in relation with pathways that allow checking receptor
downstream correlations. It is thus possible
that several pathways are reported for a same LR pair.
}
\examples{
data(bsrinf, package = "BulkSignalR")
bsrinf.redBP <- reduceToBestPathway(bsrinf)

data(bsrinf.comp, package = "BulkSignalR")


reduceToBestPathway(bsrinf.comp)

}
