% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInference-class.R
\name{BSRInference}
\alias{BSRInference}
\title{Inference of ligand-receptor interactions}
\usage{
BSRInference(
  obj,
  rank.p = 0.55,
  min.cor = 0.25,
  restrict.genes = NULL,
  reference = c("REACTOME-GOBP", "REACTOME", "GOBP"),
  max.pw.size = NULL,
  min.pw.size = NULL,
  min.positive = NULL,
  use.full.network = FALSE,
  restrict.pw = NULL,
  with.complex = NULL,
  fdr.proc = c("BH", "Bonferroni", "Holm", "Hochberg", "SidakSS", "SidakSD", "BY", "ABH",
    "TSBH")
)
}
\arguments{
\item{obj}{A BSRDataModel output by \code{\link{BSRDataModel}} with
statistical model parameters trained by the
\code{"\link[=BSRDataModel-class]{learnParameters}"} method.}

\item{rank.p}{A number between 0 and 1 defining the rank of the last
considered target genes.}

\item{min.cor}{The minimum Spearman correlation required between
the ligand and the receptor.}

\item{restrict.genes}{A list of gene symbols that restricts ligands and
receptors.}

\item{reference}{Which pathway reference should be used ("REACTOME"
for Reactome, "GOBP" for GO Biological Process,
or "REACTOME-GOBP" for both).}

\item{max.pw.size}{Maximum pathway size to consider from the pathway
reference.}

\item{min.pw.size}{Minimum pathway size to consider from the pathway
reference.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{use.full.network}{A logical to avoid limiting the reference network
to the detected genes and use the whole reference network.}

\item{restrict.pw}{A list of pathway IDs to restrict the application of
the function.}

\item{with.complex}{A logical indicating whether receptor co-complex
members should be included in the target genes.}

\item{fdr.proc}{The procedure for adjusting P-values according to
\code{\link[multtest]{mt.rawp2adjp}}.}
}
\value{
A BSRInference object with initial inferences set.
}
\description{
Computes putative LR interactions along with their statistical confidence.
In this initial inference, all the relevant pathways are reported,
see reduction functions to reduce this list.
}
\details{
Perform the initial ligand-receptor inference. Initial means that
no reduction is applied. All the (ligand, receptor, downstream pathway)
triples are reported, i.e., a given LR pair may appear multiple times
with different pathways downstream the receptor. Specific reduction
functions are available from the package to operate subsequent
simplifications based on the BSRInference object created by the initial
inference.

Parameters defining minimum/maximum pathway sizes, etc. are set to NULL
by default, meaning that their values will be taken from what was set
during the training of the statistical model with
\code{"\link[=BSRDataModel-class]{learnParameters}"}

To use different
values at the time of inference sounds like a bad idea, although this
could be used to explore without retraining the underlying model.
Retraining of the model with adjusted parameters is advised following
such an exploration.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(immune.signatures, package = "BulkSignalR")

# We use a subset of the reference to speed up
# inference in the context of the example.

reactSubset <- getResource(resourceName = "Reactome",
cache = FALSE)

subset <- c("REACTOME_BASIGIN_INTERACTIONS",
"REACTOME_SYNDECAN_INTERACTIONS",
"REACTOME_ECM_PROTEOGLYCANS",
"REACTOME_CELL_JUNCTION_ORGANIZATION")

reactSubset <- reactSubset[
reactSubset$`Reactome name` \%in\% subset,]

resetPathways(dataframe = reactSubset,
resourceName = "Reactome")

bsrinf <- BSRInference(bsrdm,
    min.cor = 0.2,restrict.genes=immune.signatures$gene,
    reference="REACTOME")
}
