% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{sspbc.models}
\alias{sspbc.models}
\title{sspbc.models: Short names for 11 SSPBC predictors}
\format{
An object of class \code{list} of length 11.
}
\usage{
data("sspbc.models")
}
\value{
\item{sspbc.models}{Named list of 11 SSP models used by \code{sspbc}.}
}
\description{
List of 11 single-sample predictor (SSP) models from Staaf et al. (2022),
indexed by short names used by \code{sspbc}.
}
\details{
Names correspond to short model identifiers. The contents are identical to
\code{sspbc.models.fullname}, which uses full model names.
}
\examples{
library(BreastSubtypeR)
data("sspbc.models")
}
\references{
Staaf J, Häkkinen J, Hegardt C, Saal LH, Kimbung S, Hedenfalk I, et al.
RNA sequencing-based single sample predictors of molecular subtype and risk of
recurrence for clinical assessment of early-stage breast cancer.
\emph{NPJ Breast Cancer}. 2022;8(1):27. https://doi.org/10.1038/s41523-022-00465-3
}
\keyword{datasets}
