% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreastSubtypeR_methods.R
\name{BS_PCAPAM50}
\alias{BS_PCAPAM50}
\title{PCA-PAM50 Intrinsic Subtyping (BS_PCAPAM50)}
\usage{
BS_PCAPAM50(se_obj, Subtype = FALSE, hasClinical = FALSE, seed = 118)
}
\arguments{
\item{se_obj}{A \code{SummarizedExperiment} object containing:
\itemize{
\item \strong{Assay data}: A log2-transformed, normalised expression matrix with
genes (Gene Symbols) as rows and samples as columns.
\item \strong{Column metadata} (\code{colData}): Must include:
\itemize{
\item \code{"PatientID"}: Unique sample or patient identifier.
\item \code{"ER"}: Estrogen receptor status, coded as \code{"ER+"} or \code{"ER-"}.
}
}}

\item{Subtype}{Logical. If \code{TRUE}, returns only the four main subtypes
(Luminal A, Luminal B, HER2-enriched, Basal-like), excluding Normal-like.}

\item{hasClinical}{Logical. If \code{TRUE}, incorporates additional clinical
variables from \code{colData(se_obj)}. Required columns:
\itemize{
\item "TSIZE": Tumor size (0 = \eqn{\le 2}{<= 2} cm; 1 = \eqn{> 2}{> 2} cm).
\item "NODE": Lymph node status (0 = negative; \eqn{\ge 1}{>= 1} = positive). Must be numeric.
}}

\item{seed}{Integer. Random seed for reproducibility.}
}
\value{
A character vector of intrinsic subtype predictions assigned to each
sample using the PCA-PAM50 method.
}
\description{
Implements the PCA-PAM50 method, which integrates \strong{Principal Component
Analysis (PCA)} of ESR1 expression to adjust for estrogen receptor (ER)
imbalance prior to applying the PAM50 nearest-centroid classifier. This
approach improves subtype consistency, particularly in ER-skewed cohorts.
}
\examples{
data("OSLO2EMIT0obj")
res <- BS_PCAPAM50(
    se_obj = OSLO2EMIT0obj$data_input$se_NC,
    Subtype = FALSE,
    hasClinical = FALSE
)

}
\references{
Raj-Kumar PK, Liu J, Hooke JA, Kovatich AJ, Kvecher L, Shriver CD, et al.
\emph{PCA-PAM50 improves consistency between breast cancer intrinsic and clinical subtyping, reclassifying a subset of luminal A tumors as luminal B.}
Scientific Reports. 2019;9(1):1–12.
https://doi.org/10.1038/s41598-019-44339-4
}
