% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skPartial.R
\name{skPartialPCA_step}
\alias{skPartialPCA_step}
\title{take a step in sklearn IncrementalPCA partial fit procedure}
\usage{
skPartialPCA_step(mat, n_components, obj)
}
\arguments{
\item{mat}{a matrix -- can be R matrix or numpy.ndarray}

\item{n_components}{number of PCA to retrieve}

\item{obj}{sklearn.decomposition.IncrementalPCA instance}
}
\value{
trained IncrementalPCA reference, to which 'transform' method can be applied to obtain projection for any compliant input
}
\description{
take a step in sklearn IncrementalPCA partial fit procedure
}
\note{
if obj is missing, the process is initialized with the matrix provided
}
\examples{
# these steps are not basilisk-compliant, you need to acquire references 
irloc = system.file("csv/iris.csv", package="BiocSklearn")
np = reticulate::import("numpy", delay_load=TRUE, convert=FALSE)
irismat = np$genfromtxt(irloc, delimiter=',')
ta = np$take
ipc = skPartialPCA_step(ta(irismat,0:49,0L))
ipc = skPartialPCA_step(ta(irismat,50:99,0L), obj=ipc)
ipc = skPartialPCA_step(ta(irismat,100:149,0L), obj=ipc)
head(names(ipc))
ipc$transform(ta(irismat,0:5,0L))
fullproj = ipc$transform(irismat)
fullpc = prcomp(data.matrix(iris[,1:4]))$x
round(cor(fullpc,fullproj),3)
}
