% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tblelementset-class.R
\name{tblelementset}
\alias{tblelementset}
\alias{.tbl_elementset}
\alias{.is_tbl_elementset}
\title{Element set representation as an S3 class tibble}
\usage{
.tbl_elementset(...)

.is_tbl_elementset(x)
}
\arguments{
\item{...}{For \code{tbl_elementset}, named character vectors of gene sets. 
Each character vector is a element set. The name of the character vector
is the name of the element set.}

\item{x}{A tibble that may or may not be an elementset}
}
\value{
For \code{tbl_elementset}, an S3 \code{elementset} object in a tibble
    representation.

For \code{.is_tbl_elementset} (internal), a logical
    indicating if the tibble is an elementset.
}
\description{
Element set representation as an S3 class tibble
}
\examples{
es <- BiocSet:::.tbl_elementset(set1 = letters, set2 = LETTERS)

BiocSet:::.is_tbl_elementset(es)
}
\keyword{internal}
