% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocVIEWSdb.R
\name{biocVIEWSdb}
\alias{biocVIEWSdb}
\title{Parse and return the VIEWS file for a Bioconductor Release}
\usage{
biocVIEWSdb(
  version = BiocManager::version(),
  pkgType = c("software", "data-experiment", "data-annotation", "workflows")
)
}
\arguments{
\item{version}{\code{character(1)} or \code{package_version} indicating the
\emph{Bioconductor} version (e.g., "3.22"). Defaults to the "current version"
provided by \code{BiocManager::version()}. The keywords "release" and "devel"
are also accepted.}

\item{pkgType}{\code{character()} The type of packages for which to get
information for. Values can be one or more of the following:
\itemize{
\item \code{software}: Software packages
\item \code{data-experiment}: Experiment data packages
\item \code{data-annotation}: Annotation data packages
\item \code{workflows}: Workflow packages
}}
}
\description{
The function parses and returns the \code{VIEWS} file for a specified Bioconductor
version, either "release" or "devel". The \code{VIEWS} file contains metadata
about Bioconductor packages, including information about their categories,
topics, and other details.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
biocVIEWSdb(pkgType = "software")
\dontshow{\}) # examplesIf}
}
