% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocBuildStatusDB.R
\name{biocBuildStatusDB}
\alias{biocBuildStatusDB}
\title{Download and parse the build status information for Bioconductor packages}
\usage{
biocBuildStatusDB(
  version = BiocManager::version(),
  pkgType = c("software", "data-experiment", "data-annotation", "workflows")
)
}
\arguments{
\item{version}{\code{character(1)} The numeric version of Bioconductor to use,
e.g., "3.19". Keywords "release" and "devel" are also accepted.}

\item{pkgType}{\code{character(1)} The type of packages for which to get build
status information for. Valid values are:
\itemize{
\item \code{software}: Software packages
\item \code{data-experiment}: Experiment data packages
\item \code{data-annotation}: Annotation data packages
\item \code{workflows}: Workflow packages
}}
}
\value{
A \code{data.frame} with the following columns:
\itemize{
\item pkg: The name of the package
\item node: The builder on which the package was built
\item stage: The stage of the build, e.g., 'install', 'buildsrc', 'checksrc',
etc.
\item result: The status of the build, e.g., 'OK', 'ERROR', 'WARNINGS', etc.
}
}
\description{
This function downloads and parses the build status information
for Bioconductor packages. The build status information is available for
the current release and the previous release. Other versions may be
available.
}
