% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compression.R
\docType{class}
\name{compression}
\alias{compression}
\alias{decompress}
\alias{decompress,ANY-method}
\alias{compress}
\alias{decompress,GZFile-method}
\alias{decompress,character-method}
\alias{CompressedFile-class}
\alias{decompress,CompressedFile-method}
\alias{fileFormat,CompressedFile-method}
\title{File compression}
\usage{
decompress(manager, con, ...)

\S4method{decompress}{ANY}(manager, con, ...)

\S4method{decompress}{CompressedFile}(manager, con, ...)

\S4method{decompress}{character}(manager, con, ...)

\S4method{fileFormat}{CompressedFile}(x)
}
\arguments{
\item{manager}{The connection manager, defaults to the internal \code{manager}
class}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[=BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{...}{Parameters to pass to the format-specific method.}

\item{x}{A \code{BiocFile} instance}
}
\value{
A decompressed representation of a \code{CompressedFile} or \code{character}
object
}
\description{
Methods and generics for file compression strategies.
}
\section{Related functions}{

\itemize{
\item \code{FileForFormat(path, format = file_ext(path))}:
Determines the file type of \code{path} and returns a high-level file object such
as BamFile, BEDFile, BigWigFile, etc.
}
}

\examples{
file <- tempfile(fileext = ".gzip")
decompress(con = file)

}
