% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/init.R, R/BiocBook.R,
%   R/BiocBook-methods.R
\docType{class}
\name{BiocBook}
\alias{BiocBook}
\alias{init}
\alias{quick_init}
\alias{BiocBook-class}
\alias{releases}
\alias{chapters}
\alias{path,BiocBook-method}
\alias{releases,BiocBook-method}
\alias{chapters,BiocBook-method}
\alias{show,BiocBook-method}
\title{Handling BiocBook directories}
\usage{
init(new_package, push = NA, skip_availability = FALSE, .local = FALSE)

quick_init(new_package, user)

BiocBook(path)

releases(object)

chapters(object)

\S4method{path}{BiocBook}(object)

\S4method{releases}{BiocBook}(object)

\S4method{chapters}{BiocBook}(object)

\S4method{show}{BiocBook}(object)
}
\arguments{
\item{new_package}{Name to use when initiating a new \code{BiocBook}.
This name should be compatible with package naming conventions
from R and Bioconductor (i.e. no \verb{_} or \code{-}, no name starting with a number).}

\item{push}{Optional. Logical, whether to automatically push commits to
remote Github origin. If NA, a prompt will ask whether to push commits or
not (default: NA).}

\item{skip_availability}{Optional. Whether to skip package name availability
(default: FALSE).}

\item{.local}{Should only be used for examples/tests. Whether to create a
matching Github repository or stay local (default: FALSE).}

\item{user}{Ideally, the Github ID of the main author/organization.}

\item{path}{Path of an existing \code{BiocBook}.}

\item{object}{A \code{BiocBook} object, created by \code{BiocBook} or \code{init()}.}
}
\value{
\itemize{
\item \code{init("newBook")} creates a local directory, synchronizes it with the
registered GitHub user, and invisibly returns a \code{BiocBook} object.
\item \code{BiocBook("newBook")} returns a \code{BiocBook} object.
\item \code{path(bb)}, \code{releases(bb)} and \code{chapters(bb)} return the corresponding
information related to the \code{bb} BiocBook.
}
}
\description{
\code{BiocBook}s are local R packages containing an extra \code{pages} folder to
write up online book chapters.
\enumerate{
\item A new \code{BiocBook} should be created using \code{init(new_package = "...")} (or
alternatively, locally with \code{quick_init(new_package = "...", user = "...")}).
\item A newly created \code{BiocBook} can be accessed to in R using \code{biocbook <- BiocBook(path = "...")}.
\item To edit an existing \code{BiocBook} object, several helper functions exist:
}
\itemize{
\item \code{add_preamble(biocbook)}
\item \code{add_chapter(biocbook, title = "...")}
\item \code{edit_page(biocbook, page = "...")}
}

Read the different sections down below for more details.
}
\section{The \code{BiocBook} class}{


A \code{BiocBook} object acts as a pointer to a local package directory, with
book chapters contained in a \verb{pages/} folder as \code{.qmd} files.

This package directory requires a specific architecture, which is
best set up using the \code{init()} function.

When created, 3 slots are defined:
\itemize{
\item \code{title}: The title contained in \verb{/inst/assets/_book.yml}
\item \code{local_path}: The absolute path to the book package directory
\item \code{remote_repository}: If the book is synced with Github, this will indicate
the remote
}
}

\section{Creating a \code{BiocBook}}{


A new \code{BiocBook} should be created using the \code{init(new_package = "...")} function.
This function performs the following operations:
\enumerate{
\item It checks that the provided package name is available;
\item It logs in the GitHub user accounts;
\item It creates a new \strong{local} repository using the \code{BiocBook} template from \code{js2264/BiocBook};
\item It pushes the local repository to a \strong{remote} Github repository;
\item It creates an empty \code{gh-pages} and sets it up to serve rendered books;
\item It edits several placeholders from the template and commits the changes.
}

The \code{init(new_package = "...")} function returns a \code{BiocBook} object.
}

\section{Quickly create a local \code{BiocBook}}{


Alternatively, a \strong{local} \code{BiocBook} can be quickly created using the
\code{quick_init(new_package = "...", user = "...")} function.

This function only creates a new \strong{local} repository, using the
\code{BiocBook} template from \code{js2264/BiocBook}.

It does \strong{NOT}:
\itemize{
\item Check that the provided package name is available;
\item Set up/push the local repository to a \strong{remote} Github repository;
\item Set up a \code{gh-pages} to serve rendered books;
}

This implies that functions committing/pushing (\code{publish()})
or checking remote status (\code{status()}) do not work properly with a
\code{BiocBook} initiated with \code{quick_init()}, unless a remote is manually
set up.

To enable Github support for a local \code{BiocBook}, one has to manually
initiate a \code{git} repository and add a remote as follows:

\if{html}{\out{<div class="sourceCode sh">}}\preformatted{git init 
git symbolic-ref HEAD refs/heads/devel
git add . 
git commit -m 'first commit'
git remote add origin git@github.com:<user>/<biocbook>.git
git push --set-upstream origin devel
}\if{html}{\out{</div>}}
}

\section{Editing an existing \code{BiocBook}}{


\code{BiocBook} objects can be modified using the following helper functions:
\itemize{
\item \code{add_preamble(biocbook)} to start writing a preamble;
\item \code{add_chapter(biocbook, title = "...")} to start writing a new chapter;
\item \code{edit_page(biocbook, page = "...")} to edit an existing chapter.
}
}

\section{Publishing an existing \code{BiocBook}}{


\strong{Important:} remember to add any dependency used in your chapters
to the DESCRIPTION before publishing your book.
Dependencies across chapters can be found with:

\code{check_deps(biocbook)}

Note that this will not always work 100\%, always use good coding practices
and add your dependencies to DESCRIPTION while writing new chapters.

To locally preview the book, one can use the following command:

\code{preview(biocbook)}

To publish changes, as long as the local \code{BiocBook} has been
initiated with \code{init()}, the writer simply has to commit changes and
push them to the \code{origin} remote. In \code{R}, this can be done as follows:

\code{publish(biocbook)}

The different available versions published in the \code{origin} \code{gh-pages} branch
can be listed with

\code{status(biocbook)}
}

\examples{
## In practice, you should not use `.local` argument. 
unique_id <- as.numeric(Sys.time())
bookname <- paste(Sys.info()[['sysname']], unique_id, sep = '.')
init(bookname, .local = TRUE)
bb <- BiocBook(bookname)
chapters(bb)
releases(bb)
unlink(bookname, recursive = TRUE)
}
