% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioTIP_update_3.3_02282020.R
\name{getNetwork}
\alias{getNetwork}
\title{Building Networks of Nodes}
\usage{
getNetwork(optimal, fdr = 0.05)
}
\arguments{
\item{optimal}{A list of x numeric data frames, where x is the number of
states studied. Each data frame consists of loci with high standard
deviations. This object can be obtained through \code{sd_selection}
function.}

\item{fdr}{A numeric cutoff value for a Pearson Correlation Coefficient
(PCC) analysis. Default is 0.05. Transcripts are linked into a network if
their correlations meet this PCC-significance criterion.}
}
\value{
A list of igraph objects whose length is the length of the input
object \code{optimal}. Each object is a network of correlated nodes whose
PCCs meet the significant criteria based on the false discovery rate (FDR)
control. The length of the list is the number of states with PCC networks.
If no PCC meets the significant criteria in a state, the state
will be deleted from the output.
}
\description{
This function builds one correlation network for each state
(sample group) and runs across all states. The network nodes are defined by
the context of the input dataset. For transcriptomic network analysis,
network nodes can be the expressed transcript IDs and network links can be
the correlation coefficients. Using the Pearson Correlation Coefficient
(PCC) analysis, this function assembles a correlation network of nodes
(e.g., co-expressed transcripts) for each state using the R package igraph.
}
\examples{
test = list('state1' = matrix(sample(1:10, 6), 2, 3), 
 'state2'=matrix(sample(1:10, 6), 2, 3), 
 'state3' = matrix(sample(1:10, 6), 2, 3))

for(i in names(test)){
  colnames(test[[i]]) = 1:3
  row.names(test[[i]]) = 1:2}

igraphL <- getNetwork(test,  fdr=1)
#[1] "state1:2 nodes"
#[1] "state2:2 nodes"
#[1] "state3:2 nodes
}
\author{
Zhezhen Wang \email{zhezhen@uchicago.edu}; Xinan H Yang \email{xyang2@uchicago.edu}
}
