% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcn_inference.R
\name{get_edge_list}
\alias{get_edge_list}
\title{Get edge list from an adjacency matrix for a group of genes}
\usage{
get_edge_list(
  net,
  genes = NULL,
  module = NULL,
  filter = FALSE,
  method = "optimalSFT",
  r_optimal_test = seq(0.4, 0.9, by = 0.1),
  Zcutoff = 1.96,
  pvalue_cutoff = 0.05,
  rcutoff = 0.7,
  nSamples = NULL,
  check_SFT = FALSE,
  bp_param = BiocParallel::SerialParam()
)
}
\arguments{
\item{net}{List object returned by \code{exp2gcn}.}

\item{genes}{Character vector containing a subset of genes from which
edges will be extracted. It can be ignored if the user wants to extract
an edge list for a given module instead of individual genes.}

\item{module}{Character with module name from which edges will be extracted.
To include 2 or more modules, input the names in a character vector.}

\item{filter}{Logical indicating whether to filter the edge list or not.}

\item{method}{Method to filter spurious correlations. One of "Zscore",
"optimalSFT", "pvalue" or "min_cor". See details for more information
on the methods. Default: 'optimalSFT'}

\item{r_optimal_test}{Numeric vector with the correlation thresholds
to be tested for optimal scale-free topology fit. Only valid
if \code{method} equals "optimalSFT". Default: seq(0.4, 0.9, by = 0.1)}

\item{Zcutoff}{Minimum Z-score threshold. Only valid if
\code{method} equals "Zscore". Default: 1.96}

\item{pvalue_cutoff}{Maximum P-value threshold. Only valid
if \code{method} equals "pvalue". Default: 0.05}

\item{rcutoff}{Minimum correlation threshold. Only valid
if \code{method} equals "min_cor". Default: 0.7}

\item{nSamples}{Number of samples in the data set from which
the correlation matrix was calculated. Only required
if \code{method} equals "pvalue".}

\item{check_SFT}{Logical indicating whether to test if the resulting network
is close to a scale-free topology or not. Default: FALSE.}

\item{bp_param}{BiocParallel back-end to be used.
Default: BiocParallel::SerialParam()}
}
\value{
Data frame with edge list for the input genes.
}
\description{
Get edge list from an adjacency matrix for a group of genes
}
\details{
The default method ("optimalSFT") will create several different
edge lists by filtering the original correlation matrix by the thresholds
specified in \code{r_optimal_test}. Then, it will calculate a scale-free
topology fit index for each of the possible networks and return the network
that best fits the scale-free topology.
The method "Zscore" will apply a Fisher Z-transformation for the correlation
coefficients and remove the Z-scores below the threshold specified
in \code{Zcutoff}.
The method "pvalue" will calculate Student asymptotic p-value for the
correlations and remove correlations whose p-values are above the threshold
specified in \code{pvalue_cutoff}.
The method "min_cor" will remove correlations below the minimum correlation
threshold specified in \code{rcutoff}.
}
\examples{
data(filt.se)
gcn <- exp2gcn(filt.se, SFTpower = 18, cor_method = "pearson")
genes <- rownames(filt.se)[1:50]
edges <- get_edge_list(gcn, genes=genes, filter = FALSE)
}
\seealso{
\code{\link[WGCNA]{scaleFreeFitIndex}}

\code{SFT_fit}

\code{exp2gcn}.
}
\author{
Fabricio Almeida-Silva
}
