% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseasePairs.R
\name{calcDiseasePairs}
\alias{calcDiseasePairs}
\title{Calculate each disease-disease pair overlap given a list of disease terms.}
\usage{
calcDiseasePairs(
  gg,
  name,
  diseases = NULL,
  permute = c("none", "random", "binned")
)
}
\arguments{
\item{gg}{interactome network as igraph object}

\item{name}{name of the attribute that stores disease annotation}

\item{diseases}{list of diseases to match}

\item{permute}{type of permutations. \code{none} -- no permutation is
applied, \code{random} -- annotation is randomly shuffled,
\code{binned} -- annotation is shuffled in a way to preserve node
degree-annotation relationship by \code{\link{degreeBinnedGDAs}}.}
}
\value{
list with three matrices:
\itemize{
\item disease_separation -- Ndisease X Ndisease matrix of separations
\item gene_disease_separation -- Ngenes X Ndisease+2 matrix of gene-disease
separation
\item disease_localisation -- matrix with diseases in rows and number of genes
(N), average and standard deviation of gene-disease separation in columns
}
}
\description{
Calculate each disease-disease pair overlap (or separation) on a given PPI
network model, based on analysis described in Menche et al. 2015
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
gg <- igraph::read_graph(file, format="gml")
agg<-annotateGeneNames(gg)
# due to error in org.Hs.eg.db we have to manually check annotation of one node
idx <- which(V(agg)$name == '80273')
paste(V(agg)$GeneName[idx], 'GRPEL1')
p <- calcDiseasePairs(
agg,
name = "TopOntoOVGHDOID",
diseases = c("DOID:10652", "DOID:3312", "DOID:12849"),
permute = "n"
)
p$disease_separation
}
\references{
Menche, J. et al. Uncovering disease-disease relationships
through the incomplete interactome.
Science, 347, (6224):1257601 (2015).
}
\seealso{
degreeBinnedGDAs

sampleDegBinnedGDA
}
