% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{calcClustering}
\alias{calcClustering}
\title{Calculate community membership for given clustering algorithm and store the
results as new vertex attributes in the graph..}
\usage{
calcClustering(gg, alg, weights = NULL)
}
\arguments{
\item{gg}{igraph object to cluster}

\item{alg}{algorithm to apply}

\item{weights}{The weights of the edges. It must be a positive numeric
vector, NULL or NA. If it is NULL and the input graph has a ‘weight’
edge attribute, then that attribute will be used. If NULL and no such
attribute is present, then the edges will have equal weights. Set
this to NA if the graph was a ‘weight’ edge attribute, but you don't
want to use it for community detection. A larger edge weight means a
stronger connection for this function. The weights value is ignored
for the \code{spectral} clustering.}
}
\value{
modified igraph object with calculated membership stored as a vertex
attribute and modularity as a graph attribute
}
\description{
When applying resampling the clustering results of a clustering algorithm
applied to a graph can differ due to the stochastic nature of the resampling
algorithm. To allow reproducible downstream analysis clustering results are
stored as vertex attributes in the graph. This function call
\code{\link{getClustering}} and stores community membership as new vertex
attribute in the graph, and Modularity as a new graph attribute prefix with
the \code{alg} name.
}
\details{
NOTE: \code{\link{getClustering}} verifies algorithm names with
\code{\link[base]{match.arg}} so correct membership will be calculated, but
name of the attribute is taken from \code{alg} argument, so it is possible
that vertex attribute name won't exactly match name of the algorithm from
\code{link{getClustering}}.
}
\examples{
karate <- make_graph("Zachary")
# We need vertex ID in the 'name' attribute of the vertex
V(karate)$name<-c(LETTERS,letters)[1:vcount(karate)]
g<-calcClustering(karate, 'louvain')
vertex_attr_names(g)
graph_attr(g, 'louvain')
}
\seealso{
getClustering
}
