% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPowerLaw.R
\name{fitDegree}
\alias{fitDegree}
\title{Fit Power Law to degree distribution.}
\usage{
fitDegree(
  DEG,
  Nsim = 100,
  plot = FALSE,
  DATAleg = "Fit power-law",
  threads = 4,
  WIDTH = 480,
  HEIGHT = 480,
  legpos = "bottomleft",
  showErr = TRUE
)
}
\arguments{
\item{DEG}{degree distribution}

\item{Nsim}{number of bootstrap iterations}

\item{plot}{logical, do you want plot to be drawn}

\item{DATAleg}{legend string for degree data}

\item{threads}{number of parallel computational threads}

\item{WIDTH}{width of the plot in ptx}

\item{HEIGHT}{heigth of the plot in ptx}

\item{legpos}{position of the legend @seealso \code{\link[=legend]{legend()}}}

\item{showErr}{logical, do you want error on the plot legend}
}
\value{
an object of class \code{\link{law-class}} with results of fitting
}
\description{
Fit a Powerlaw distribution to graph's degree distribution using the R
“PoweRlaw” package (version 0.50.0) (Gillespie, 2015)
}
\examples{
##No: of bootstrap iterations use nsim > 100 for reliable result
nsim <- 10

##Legend Titles
Legend <- "Presynaptic PPI"

file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
gg <- igraph::read_graph(file, format="gml")
pFit <- fitDegree( as.vector(igraph::degree(graph=gg)),
DATAleg=Legend,threads=1, Nsim=nsim)
}
