% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{getRandomGraphCentrality}
\alias{getRandomGraphCentrality}
\title{Centrality measures for random graphs induced by input one}
\usage{
getRandomGraphCentrality(
  gg,
  type = c("gnp", "pa", "cgnp", "rw"),
  power = NULL,
  weights = NULL,
  ...
)
}
\arguments{
\item{gg}{template graph to mimic}

\item{type}{type of random graph to generate:
\itemize{
\item gnp -- G(n,p) Erdos-Renyi model (\code{\link[igraph]{sample_gnp}})
\item pa --  Barabasi-Albert model (\code{\link[igraph]{sample_pa}})
\item cgnp -- new random graph from a given graph by randomly a
dding/removing edges (\code{\link[igraph]{sample_correlated_gnp}})
\item rw -- new random graph from a given graph by rewiring 25\% of
edges preserving the degree distribution
\code{\link[igraph]{sample_gnp}},
\code{\link[igraph]{sample_correlated_gnp}}, and
\code{\link[igraph]{sample_pa}}
}}

\item{power}{optional argument of the power of the preferential attachment
to be passed to \code{\link[igraph]{sample_pa}}. If \code{power} is
\code{NULL} the power of the preferential attachment will be estimated
from \code{\link{fitDegree}} function.}

\item{weights}{Possibly a numeric vector giving edge weights. If this is
NULL and the graph has a weight edge attribute, then the attribute
is used. If this is NA then no weights are used (even if the graph
has a weight attribute).}

\item{...}{other parameters passed to random graph generation functions}
}
\value{
matrix of random graph vertices centrality measure.
}
\description{
Generate a random graph that mimics the properties of the input graph and
calls \code{\link{getCentralityMatrix}} to calculate all available vertex
centrality measures. There are four different types of random graph to
generate
}
\examples{
data(karate,package='igraphdata')
m<-getRandomGraphCentrality(karate,'pa',threads=1)
# to avoid repetitive costy computation of PowerLaw fit
# power parameter could be send explicitly:
pFit <- fitDegree( as.vector(igraph::degree(graph=karate)),
Nsim=10, plot=FALSE,threads=1)
pwr <- slot(pFit,'alpha')
m<-getRandomGraphCentrality(karate,'pa',power=pwr)
lpa<-lapply(1:5,getRandomGraphCentrality,gg=karate,type='pa',
            power=pwr,weights = NULL)
}
\seealso{
\code{\link[=getCentralityMatrix]{getCentralityMatrix()}} for explanation of the use of \code{weights}.
}
