% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamo.R
\name{getDYNAMO}
\alias{getDYNAMO}
\title{Calculate DYNAMO sensitivity matrix.}
\usage{
getDYNAMO(g, attr = NULL, vid = "name", alpha = 0.9)
}
\arguments{
\item{g}{igraph object}

\item{attr}{NULL or the name of edge attribute containing numerical weight
values}

\item{vid}{name of the vertex attribute to be used as row and column names}

\item{alpha}{parameter characterizing the propagation strength, default
value 0.9 taken from Santolini paper.}
}
\value{
sparce sensitivity matrix defined by the network topology and
edge values
}
\description{
This function calculates sensitivity matrix that represents perturbation
patterns defined by topology and edge weights of the network. If weights
are signed value sensitivity matrix is able to reproduce not only activation
but inhibition relationships in the network.
}
\details{
Algorithm proposed in:

Santolini,M. and Barabasi,A.-L. (2018) Predicting perturbation patterns from
the topology of biological networks. Proc Natl Acad Sci USA, 169, 201720589.
}
\examples{
data(karate, package='igraphdata')
upgrade_graph(karate)
d<-getDYNAMO(karate,attr='weight')
df<-metlMatrix(d)
head(df)
}
