% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildNetwork.R
\name{calcSparsness}
\alias{calcSparsness}
\title{Calculate sparsness of the graph.}
\usage{
calcSparsness(gg)
}
\arguments{
\item{gg}{graph to evaluate}
}
\value{
sparsness value
}
\description{
For a simple unweighted, undirected graph G(N,E).
Network sparseness is defined as the ratio of the actual number of graph
edges (E) to the maximum number of edges possible in a graph with same number
of vertices (N):  E/binom(N,2)
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.csv", package = "BioNAR")
tbl <- read.csv(file, sep="\t")
gg <- buildNetwork(tbl)
calcSparsness(gg)
}
