% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridgeness.R
\name{calcBridgeness}
\alias{calcBridgeness}
\title{Helper function that uses \code{\link{getBridgeness}} to calculate
graph node bridgeness values for selected algorithm and consensus matrix
and save them as a graph attribute \code{BRIDGENESS.<alg>} with \code{<alg>}
replaced by the selected algorithm name.}
\usage{
calcBridgeness(gg, alg, conmat)
}
\arguments{
\item{gg}{igraph object}

\item{alg}{clustering algorithm}

\item{conmat}{consensus matrix calculated with that algorithm}
}
\value{
graph with additional attributes to store Bridgeness value
}
\description{
Helper function that uses \code{\link{getBridgeness}} to calculate
graph node bridgeness values for selected algorithm and consensus matrix
and save them as a graph attribute \code{BRIDGENESS.<alg>} with \code{<alg>}
replaced by the selected algorithm name.
}
\examples{
library(BioNAR)
karate <- make_graph("Zachary")
# We need vertex ID in the 'name' attribute of the vertex
V(karate)$name<-c(LETTERS,letters)[1:vcount(karate)]
set.seed(100)
gg <- calcClustering(karate, 'louvain')
cnmat <- makeConsensusMatrix(gg, N=10, alg = 'louvain', type = 2, mask = 10)
gg<-calcBridgeness(gg, alg = 'louvain', cnmat)
hist(V(gg)$BRIDGENESS.louvain)
}
\seealso{
getBridgeness
}
