% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{setMeta}
\alias{setMeta}
\alias{setMeta,BSFDataSet-method}
\title{Setter method for the meta data of the BSFDataSet object}
\usage{
setMeta(object, ...)

\S4method{setMeta}{BSFDataSet}(object, newMeta)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{...}{additional arguments}

\item{newMeta}{the replacement meta data table}
}
\value{
an object of type \code{\link{BSFDataSet}} with updated meta data
}
\description{
Meta data is stored as a \code{data.frame} and must contain the columns
"condition", "clPlus" and "clMinus".
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

nMeta = getMeta(bds)
setMeta(bds, nMeta)

}
\seealso{
\code{\link{BSFDataSet}}
}
