% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{globalScorePlot}
\alias{globalScorePlot}
\title{Plot the PureCLIP score distribution after re-assignment}
\usage{
globalScorePlot(object)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the PureCLIP score distribution on a log2
scale after the re-assignment on binding site level.
The function \code{\link{annotateWithScore}} is expected to be executed
prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
bds1 = makeBindingSites(object = bds, bsSize = 9)
bds1 = annotateWithScore(bds1, match.ranges = getRanges(bds))
globalScorePlot(bds1)

}
\seealso{
\code{\link{annotateWithScore}}
}
