% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesKnockdown.r
\name{BayesKnockdown.es}
\alias{BayesKnockdown.es}
\title{Posterior Probabilities for ExpressionSet Data}
\usage{
BayesKnockdown.es(es, predFeature, prior = 0.5, g = sqrt(dims(es)[2,1]))
}
\arguments{
\item{es}{An ExpressionSet object with \code{p} features and \code{n} samples.}

\item{predFeature}{The name of the feature to use as the predictor.}

\item{prior}{Prior probabilities for the outcome variables. Defaults to 0.5
for all variables.}

\item{g}{The value to use for Zellner's \emph{g}-prior.
Defaults to the square root of the number of observations.}
}
\value{
A vector of \code{p-1} posterior probabilities indicating
             the probability of a relationship between the predictor variable
             and each outcome variable.
}
\description{
Calculates posterior probabilities for an ExpressionSet object by defining
one feature as the predictor. Each other feature in the ExpressionSet is
is then used as a response variable and posterior probabilities are
calculated, incorporating prior probabilities potentially unique to each
response variable.
}
\examples{
library(Biobase);
data(sample.ExpressionSet);
subset <- sample.ExpressionSet[1:10,];

BayesKnockdown.es(subset, "AFFX-MurIL10_at");
}

