% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeNormalChromosomes.R
\name{computeNormalChromosomes}
\alias{computeNormalChromosomes}
\title{computeNormalChromosomes}
\usage{
computeNormalChromosomes(
  segments,
  tolerance_val = 0.15,
  maxCN = 6,
  min_threshold = 1.6,
  max_threshold = 2.4,
  verbose = FALSE
)
}
\arguments{
\item{segments}{data.frame formatted with correct column names}

\item{tolerance_val}{decimal value of alteration frequency. By default is 0.15}

\item{maxCN}{threshold of max copy number to consider. By default is 6}

\item{min_threshold}{minimum threshold to define a normal CN. By default is 1.60}

\item{max_threshold}{maximum threshold to define a normal CN. By default is 2.40}

\item{verbose}{print information about the processes of the function. By default is FALSE}
}
\value{
vector with chromosome names and plot with the alteration rate of each chromosomal arms
}
\description{
This function compute the DRrefits' input "chromosome list". It is a vector that contains the chromosomal arms considered "normal" in the cohort of samples tested (BED file), under a specific tolerance value
}
\examples{
data("TCGA_BRCA_CN_segments")
chr_list <- computeNormalChromosomes(segments = TCGA_BRCA_CN_segments)
}
