% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findOutsideValues.R
\name{findOutsideValues}
\alias{findOutsideValues}
\title{Find DNA methylation values out of the boundaries}
\usage{
findOutsideValues(data)
}
\arguments{
\item{data}{any matrix filled with values that normally should be bounded
between 0 and 1.}
}
\value{
A data frame containing the columns "level", "row", "col" and "value"
defining if the value is below 0 or beyond 1 (level = 0 or level = 1),
the row position and the column position in the input matrix and the
value itself, respectively.
}
\description{
A method which lists values below 0 or beyond 1 contained in the
input matrix. These entries are stored in a data.frame together with the
corresponding row and column position of the matrix. Note that this method is
especially designed for DNA methylation data.
}
\details{
findOutsideValues

Note that this method is especially designed to run after the batch
effect correction of DNA methylation data, e.g. with the
\code{\link{correctBatchEffect}} method. It can happen, that the predicted values are
lying slightly below the lower bound of 0 or beyond the upper bound of 1.
This method finds these inaccurately predicted entries. Another method called
\code{\link{replaceOutsideValues}} replaces these values either by 0 or 1,
respectively.
}
\examples{
data(BEclearCorrected)
# Find predicted values outside of the boundaries
outsideEntries <- findOutsideValues(data = ex.corrected.data)
}
\seealso{
\code{\link{replaceOutsideValues}}

\code{\link{correctBatchEffect}}
}
