test_that("BASiCS_EffectiveSize works", {
  data(ChainSC)
  ess <- BASiCS_EffectiveSize(ChainSC, Param = "mu")
  expect_type(ess, "double")
  expect_equal(ess[[1]], 129.73861)
  expect_warning(
    BASiCS_effectiveSize(ChainSC, Param = "mu"),
    "'BASiCS_effectiveSize' is deprecated."
  )
})

test_that("utils work", {
  data(ChainSC)
  expect_equal(BASiCS:::.DistanceName("ResDisp"), "distance")
  expect_equal(BASiCS:::.DistanceName("Mean"), "fold change")
  expect_equal(BASiCS:::.LogDistanceName("ResDisp"), "distance")
  expect_equal(BASiCS:::.LogDistanceName("Mean"), "log2(fold change)")
  expect_equal(BASiCS:::.cap("test"), "Test")
  expect_equal(BASiCS:::.NSamples(ChainSC), 75)
  expect_equal(BASiCS:::.MeasureName("Mean"), "mean expression")
  expect_equal(BASiCS:::.MeasureName("Disp"), "over dispersion")
  expect_equal(BASiCS:::.MeasureName("ResDisp"), "residual over dispersion")
})

test_that("ERCC works", {
  expectedERCC <- c(3251.9560104, 812.9890026, 203.24725065, 101.623625325, 50.8118126625, 
    25.40590633125, 12.702953165625, 12.702953165625, 6.3514765828125, 
    3.17573829140625, 3.17573829140625, 1.58786914570313, 0.793934572851563, 
    0.793934572851563, 0.396967286967774, 0.198483643483887, 0.198483643483887, 
    0.0992418211999508, 0.0496209105999754, 0.0496209105999754, 0.0248104558419804, 
    0.0124052279209902, 0.00310130698024755, 1625.9780052, 406.4945013, 
    101.623625325, 50.8118126625, 25.40590633125, 12.702953165625, 
    6.3514765828125, 6.3514765828125, 3.17573829140625, 1.58786914570313, 
    1.58786914570313, 0.793934572851563, 0.396967286967774, 0.396967286967774, 
    0.198483643483887, 0.0992418211999508, 0.0992418211999508, 0.0496209105999754, 
    0.0248104558419804, 0.0248104558419804, 0.0124052279209902, 0.00620261396049509, 
    0.00155065403211644, 1625.9780052, 406.4945013, 101.623625325, 
    50.8118126625, 25.40590633125, 12.702953165625, 6.3514765828125, 
    6.3514765828125, 3.17573829140625, 1.58786914570313, 1.58786914570313, 
    0.793934572851563, 0.396967286967774, 0.396967286967774, 0.198483643483887, 
    0.0992418211999508, 0.0992418211999508, 0.0496209105999754, 0.0248104558419804, 
    0.0248104558419804, 0.0124052279209902, 0.00620261396049509, 
    0.00155065403211644, 1625.9780052, 406.4945013, 101.623625325, 
    50.8118126625, 25.40590633125, 12.702953165625, 6.3514765828125, 
    6.3514765828125, 3.17573829140625, 1.58786914570313, 1.58786914570313, 
    0.793934572851563, 0.396967286967774, 0.396967286967774, 0.198483643483887, 
    0.0992418211999508, 0.0992418211999508, 0.0496209105999754, 0.0248104558419804, 
    0.0248104558419804, 0.0124052279209902, 0.00620261396049509, 
    0.00155065403211644
  )
  names(expectedERCC) <- c("ERCC-00130", "ERCC-00004", "ERCC-00136", "ERCC-00108", 
                           "ERCC-00116", "ERCC-00092", "ERCC-00095", "ERCC-00131", 
                           "ERCC-00062", "ERCC-00019", "ERCC-00144", "ERCC-00170", 
                           "ERCC-00154", "ERCC-00085", "ERCC-00028", "ERCC-00033", 
                           "ERCC-00134", "ERCC-00147", "ERCC-00097", "ERCC-00156", 
                           "ERCC-00123", "ERCC-00017", "ERCC-00083", "ERCC-00096", 
                           "ERCC-00171", "ERCC-00009", "ERCC-00042", "ERCC-00060",
                           "ERCC-00035", "ERCC-00025", "ERCC-00051", "ERCC-00053", 
                           "ERCC-00148", "ERCC-00126", "ERCC-00034", "ERCC-00150", 
                           "ERCC-00067", "ERCC-00031", "ERCC-00109", "ERCC-00073", 
                           "ERCC-00158", "ERCC-00104", "ERCC-00142", "ERCC-00138", 
                           "ERCC-00117", "ERCC-00075", "ERCC-00074", "ERCC-00113", 
                           "ERCC-00145", "ERCC-00111", "ERCC-00076", "ERCC-00044", 
                           "ERCC-00162", "ERCC-00071", "ERCC-00084", "ERCC-00099",
                           "ERCC-00054", "ERCC-00157", "ERCC-00143", "ERCC-00039", 
                           "ERCC-00058", "ERCC-00120", "ERCC-00040", "ERCC-00164", 
                           "ERCC-00024", "ERCC-00016", "ERCC-00012", "ERCC-00098", 
                           "ERCC-00057", "ERCC-00002", "ERCC-00046", "ERCC-00003", 
                           "ERCC-00043", "ERCC-00022", "ERCC-00112", "ERCC-00165", 
                           "ERCC-00079", "ERCC-00078", "ERCC-00163", "ERCC-00059", 
                           "ERCC-00160", "ERCC-00014", "ERCC-00077", "ERCC-00069",
                           "ERCC-00137", "ERCC-00013", "ERCC-00168", "ERCC-00041", 
                           "ERCC-00081", "ERCC-00086", "ERCC-00061", "ERCC-00048")
  expect_equal(
    BASiCS_CalculateERCC(Mix = 1, DilutionFactor = 1/50000, VolumePerCell = 0.009),
    expectedERCC  
  )
})
