% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_LoadChain.R
\name{BASiCS_LoadChain}
\alias{BASiCS_LoadChain}
\title{Loads pre-computed MCMC chains generated by the
\code{\link[BASiCS]{BASiCS_MCMC}} function}
\usage{
BASiCS_LoadChain(RunName = "", StoreDir = getwd(), StoreUpdatedChain = FALSE)
}
\arguments{
\item{RunName}{String used to index `.Rds` file containing the MCMC chain
(produced by the \code{\link[BASiCS]{BASiCS_MCMC}} function, with
\code{StoreChains = TRUE})}

\item{StoreDir}{Directory where `.Rds` file is stored.
Default: \code{StoreDir = getwd()}}

\item{StoreUpdatedChain}{Only required when the input files contain an
outdated version of a \code{\linkS4class{BASiCS_Chain}} object.
If \code{StoreUpdatedChain = TRUE}, an updated object is saved
(this overwrites original input file, if it was an `.Rds` file).}
}
\value{
An object of class \code{\linkS4class{BASiCS_Chain}}.
}
\description{
Loads pre-computed MCMC chains generated by the
\code{\link[BASiCS]{BASiCS_MCMC}} function, creating
a \code{\linkS4class{BASiCS_Chain}}  object
}
\examples{

Data <- makeExampleBASiCS_Data()
Chain <- BASiCS_MCMC(
  Data,
  N = 50,
  Thin = 5,
  Burn = 5,
  Regression = FALSE,
  StoreChains = TRUE,
  StoreDir = tempdir(),
  RunName = "Test"
)
ChainLoad <- BASiCS_LoadChain(RunName = "Test", StoreDir = tempdir())
}
\seealso{
\code{\link[BASiCS]{BASiCS_Chain}}
}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}
}
