% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Assessment-class.R
\name{plot.Assessment}
\alias{plot.Assessment}
\title{Plot Assessment Objects}
\usage{
\method{plot}{Assessment}(
  x,
  y = NULL,
  minConCovRatio_GV = 0.8,
  interactive_GV = TRUE,
  rangeStart_GV = NA_integer_,
  rangeEnd_GV = NA_integer_,
  ...
)
}
\arguments{
\item{x}{An object of class \code{Assessment} and of either subclass \code{DataMap} or subclass \code{Results}.}

\item{y}{An optional object of class \code{Assessment} and of either subclass \code{DataMap} or subclass \code{Results}. Its
subclass must be different than the subclass of \code{x}}

\item{minConCovRatio_GV}{Minimum value of the conservation to coverage ratio needed to call a start conserved. Must range
from 0 to 1. Lower values allow more conserved starts through. Only used with the genome viewer. Default value is recommended.}

\item{interactive_GV}{Logical specifying whether or not the genome viewer plot should be interactive. Default is TRUE.}

\item{rangeStart_GV, rangeEnd_GV}{Optional positive integer values that can be specified when generating a genome viewer plot in
order to have the plot zoom into the range of genomic positions between those values. Both values must be within the bounds of
the genome. Omitted (NA) by default, which results in a plot spanning the whole genome.}

\item{...}{Further plotting parameters.}
}
\value{
Invisibly returns the input object \code{x}
}
\description{
The \code{plot} method for \code{Assessment} objects
}
\details{
If out of \code{x} and \code{y} only \code{x} is specified and \code{x} is of subclass \code{Results}, a bar chart describing
the number of genes in each category is plotted. For the predicted gene categories, bars are colored by the correctness of
that category, where dark green represents "definitely correct", light green represents "likely correct", white represents
"no evidence", dark red represents "definitely incorrect", light red represents "likely incorrect", and grey represents
"potentially incorrect". For the two categories that come from ORFs without predicted genes, dark blue represents
"likely missing" and light blue represents "potentially missing".

If out of \code{x} and \code{y} only \code{x} is specified and \code{x} is of subclass \code{DataMap}, a genome viewer plot
showing how the proteomics data and evolutionary conservation data map to the central genome is generated.

If both \code{x} and \code{y} are specified, each of a different subclass, a genome viewer plot showing how the proteomics
data, evolutionary conservation data, and set of predicted genes map to the central genome is generated.

## The genome viewer

In the genome viewer plot, predicted starts are magenta lines, predicted stops are cyan lines, genome stops are yellow lines,
conserved starts are gray lines, and proteomic hits are blue / red / green blocks.

If \code{interactive_GV} is set to FALSE, a static genome viewer plot is generated. If \code{interactive_GV} is set to TRUE,
a genome viewer plot that can be interacted with using the \code{locator} is generated. In order to interact with the plot,
the user needs to click on the graphics window one or more times and then terminate the locator. One click will scroll the
viewer either to the left or the right (based on which side is closer to the click). Two clicks will zoom the viewer into the
horizontal range between the two click points. Three clicks will zoom out 10-fold, and four clicks will zoom out completely to
the entire genome. To stop interaction with the locator, click zero times then terminate the locator. Depending on the
graphical device, terminating the locator can either done by pressing the 'Finish' / 'Stop' button, hitting the 'Esc' key, or
right-clicking the graphics device.

If both \code{rangeStart_GV} and \code{rangeEnd_GV} are validly specified, the genome viewer will only span the range of
genomic positions between those two values. If interaction is turned on with \code{interactive_GV} and a static plot is not
being generated, this only applies to the initial state of the genome viewer plot. By default, \code{rangeStart_GV} and
\code{rangeEnd_GV} are not specified, resulting in the genome viewer covering all positions in the genome (at least to start).
WARNING: plotting the whole genome at once may overwhelm some graphical devices and cause R to slow down or crash, so it is
recommended to avoid doing so unless absolutely necessary.
}
\examples{

currMapObj <- readRDS(system.file("extdata",
                                  "MGAS5005_PreSaved_DataMapObj.rds",
                                  package = "AssessORF"))

currResObj <- readRDS(system.file("extdata",
                                  "MGAS5005_PreSaved_ResultsObj_Prodigal.rds",
                                  package = "AssessORF"))

plot(currMapObj)

plot(currResObj)

plot(currMapObj, currResObj)

plot(currResObj, currMapObj)

}
\seealso{
\code{\link{Assessment-class}}, \code{\link{locator}}
}
