% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avtable-methods.R
\name{avtable-methods}
\alias{avtable-methods}
\alias{avtable,missing-method}
\alias{avtable,ANY-method}
\alias{avtables,missing-method}
\alias{avtables,ANY-method}
\alias{avtable_import,missing-method}
\alias{avtable_import,ANY-method}
\alias{avtable_import_set,missing-method}
\alias{avtable_import_set,ANY-method}
\alias{avtable_delete,missing-method}
\alias{avtable_delete,ANY-method}
\alias{avtable_delete_values,missing-method}
\alias{avtable_delete_values,ANY-method}
\title{The avtable methods for 'missing' and 'ANY' signatures}
\usage{
\S4method{avtable}{missing}(..., platform)

\S4method{avtable}{ANY}(..., platform)

\S4method{avtables}{missing}(..., platform)

\S4method{avtables}{ANY}(..., platform)

\S4method{avtable_import}{missing}(..., platform)

\S4method{avtable_import}{ANY}(..., platform)

\S4method{avtable_import_set}{missing}(..., platform)

\S4method{avtable_import_set}{ANY}(..., platform)

\S4method{avtable_delete}{missing}(..., platform)

\S4method{avtable_delete}{ANY}(..., platform)

\S4method{avtable_delete_values}{missing}(..., platform)

\S4method{avtable_delete_values}{ANY}(..., platform)
}
\arguments{
\item{...}{Arguments passed to the methods.}

\item{platform}{A Platform derived class indicating the AnVIL environment,
currently, \code{azure} and \code{gcp} classes are compatible.}
}
\value{
Methods for the 'missing' and 'ANY' signatures provide a way to
redirect calls to the appropriate method for the current cloud platform.
}
\description{
The \code{AnVILBase} package defines S4 methods for the AnVIL
package. These methods are defined for the 'missing' and 'ANY' signatures.
}
\section{Functions}{
\itemize{
\item \code{avtable(missing)}: Show the contents of a particular table (entity
/ type) within a workspace.

\item \code{avtable(ANY)}: Show the contents of a particular table (entity
/ type) within a workspace.

\item \code{avtables(missing)}: List entities / types accross or within
the current workspace respectively.

\item \code{avtables(ANY)}: List entities / types accross or within
the current workspace respectively.

\item \code{avtable_import(missing)}: Upload a dataset to the DATA tab

\item \code{avtable_import(ANY)}: Upload a dataset to the DATA tab

\item \code{avtable_import_set(missing)}: Creates a grouping table for each
distinct value in the column identified by \code{set}.

\item \code{avtable_import_set(ANY)}: Creates a grouping table for each
distinct value in the column identified by \code{set}.

\item \code{avtable_delete(missing)}: Delete a table

\item \code{avtable_delete(ANY)}: Delete a table

\item \code{avtable_delete_values(missing)}: Delete a row in a table based on the key

\item \code{avtable_delete_values(ANY)}: Delete a row in a table based on the key

}}
\examples{
findMethods("avtable")
getMethod("avtable", c(platform = "missing"))

}
