% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{avbase-utilities}
\alias{avbase-utilities}
\alias{avstop_for_status}
\alias{avworkspaces_clean}
\title{Helper functions for working in AnVIL}
\usage{
avstop_for_status(response, op)

avworkspaces_clean(.data)
}
\arguments{
\item{response}{Response object from httr}

\item{op}{Operation that was attempted}

\item{.data}{A tibble with workspace information}
}
\value{
\code{avstop_for_status} - \code{response} if status code less than 400
otherwise throw an error

\code{avworkspaces_clean} - A cleaned tibble with workspace information
}
\description{
\itemize{
\item \code{avstop_for_status} - Check HTTP status code and raise error when
less than 400.
}

\itemize{
\item \code{avworkspaces_clean} - Clean workspace information
}
}
\examples{
if (interactive()) {
    test <- httr::GET("http://google.com/")
    avstop_for_status(test, "google")
}

}
