% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABneutralSOMA.R
\name{ABneutralSOMA}
\alias{ABneutralSOMA}
\title{Model with no selection (outneutral)}
\usage{
ABneutralSOMA(pedigree.data, p0uu, eqp, eqp.weight, Nstarts, out.dir, out.name)
}
\arguments{
\item{pedigree.data}{pedigree data.}

\item{p0uu}{initial proportion of unmethylated cytosines.}

\item{eqp}{equilibrium proportion of unmethylated cytosines.}

\item{eqp.weight}{weight assigned to equilibrium function.}

\item{Nstarts}{iterations for non linear LSQ optimization.}

\item{out.dir}{output directory.}

\item{out.name}{output file name.}
}
\value{
ABneutralSoma RData file.
}
\description{
This model assumes that somatically heritable gains and losses in cytosine methylation are selectively neutral.
}
\examples{
#Get some toy data
inFile <- readRDS(system.file("extdata/soma/","outputSoma.rds", package="AlphaBeta"))
pedigree <- inFile$Pdata
p0uu_in <- inFile$tmpp0
eqp.weight <- 0.001
Nstarts <- 2
out.name <- "ABneutralSOMA_CG_estimates"
out <- ABneutralSOMA(pedigree.data = pedigree,
                  p0uu=p0uu_in,
                  eqp=p0uu_in,
                  eqp.weight=eqp.weight,
                  Nstarts=Nstarts,
                  out.dir=getwd(),
                  out.name=out.name)

summary(out)

}
