% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variabilityIndex.r
\name{variabilityIndex}
\alias{variabilityIndex}
\title{Variability Index}
\usage{
variabilityIndex(studies, afunction, B = 10, silence = FALSE)
}
\arguments{
\item{studies}{a list of K studies. 
Each element (kth study) of the list is another list consisting 
gene expression matrix and and label information.}

\item{afunction}{A function for DE analysis. 
Options can be function_limma or function_edgeR. 
Default option is function_limma. 
However, use could define their own function. 
The input of afunction should be list(data, label) 
which is consistent with one element of the studies list/argument. 
The return of afunction should be list(pvalue=apvalue, effectSize=aeffectsize)}

\item{B}{number of permutation should be used. B=1000 is suggested.}

\item{silence}{If TRUE, will print out the bootstrapping procedure.}
}
\value{
A list consisting of biomarker categrorization result.
\item{varibility}{Varibility index for all genes}
}
\description{
Variability Index
}
\details{
Variability Index via boostrap AW weight.
}
\examples{
N0 = 10
G <- 1000
GDEp <- 50
GDEn <- 50
K = 4

studies <- NULL
set.seed(15213)
for(k in 1:K){
    astudy <- matrix(rnorm(N0*2*G),nrow=G,ncol=N0*2)
    ControlLabel <- 1:N0
    caseLabel <- (N0 + 1):(2*N0)

    astudy[1:GDEp,caseLabel] <- astudy[1:GDEp,caseLabel] + 2
    astudy[1:GDEp + GDEn,caseLabel] <- astudy[1:GDEp + GDEn,caseLabel] - 2

    alabel = c(rep(0,length(ControlLabel)),rep(1,length(caseLabel)))

    studies[[k]] <- list(data=astudy, label=alabel)
}


result <- variabilityIndex(studies,function_limma,B=100)
head(result)
}
\author{
Zhiguang Huo
}
