#' @title Transcription Factor Enrichment Analysis for ATAC-seq
#'
#' @description Assay for Transpose-Accessible Chromatin using sequencing
#' (ATAC-seq) is a technique to assess genome-wide chromatin accessibility
#' by probing open chromatin with hyperactive mutant Tn5 Transposase that
#' inserts sequencing adapters into open regions of the genome.
#' ATACseqTFEA is an improvement of the current computational method that
#' detects differential activity of transcription factors (TFs).
#' ATACseqTFEA not only uses the difference of open region information,
#' but also (or emphasizes) the difference of TFs footprints
#' (cutting sites or insertion sites). ATACseqTFEA provides an easy,
#' rigorous way to broadly assess TF activity changes between two conditions.
"_PACKAGE"
