% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.mcmc.R
\name{assign.mcmc}
\alias{assign.mcmc}
\title{The Gibbs sampling algorithm to approximate the joint distribution of the
model parameters}
\usage{
assign.mcmc(
  Y,
  Bg,
  X,
  Delta_prior_p,
  iter = 2000,
  adaptive_B = TRUE,
  adaptive_S = FALSE,
  mixture_beta = TRUE,
  sigma_sZero = 0.01,
  sigma_sNonZero = 1,
  p_beta = 0.01,
  sigma_bZero = 0.01,
  sigma_bNonZero = 1,
  alpha_tau = 1,
  beta_tau = 0.01,
  Bg_zeroPrior = TRUE,
  S_zeroPrior = FALSE,
  ECM = FALSE,
  progress_bar = TRUE
)
}
\arguments{
\item{Y}{The G x J matrix of genomic measures (i.g., gene expression) of test
samples. Y is the testData_sub variable returned from the data.process
function. Genes/probes present in at least one pathway signature are
retained.}

\item{Bg}{The G x 1 vector of genomic measures of the baseline/background
(B). Bg is the B_vector variable returned from the data.process function. Bg
is the starting value of baseline/background level in the MCMC chain.}

\item{X}{The G x K matrix of genomic measures of the signature. X is the
S_matrix variable returned from the data.process function. X is the starting
value of pathway signatures in the MCMC chain.}

\item{Delta_prior_p}{The G x K matrix of prior probability of a gene being
"significant" in its associated pathway. Delta_prior_p is the Pi_matrix
variable returned from the data.process function.}

\item{iter}{The number of iterations in the MCMC. The default is 2000.}

\item{adaptive_B}{Logicals. If TRUE, the model adapts the
baseline/background (B) of genomic measures for the test samples. The
default is TRUE.}

\item{adaptive_S}{Logicals. If TRUE, the model adapts the signatures (S) of
genomic measures for the test samples. The default is FALSE.}

\item{mixture_beta}{Logicals. If TRUE, elements of the pathway activation
matrix are modeled by a spike-and-slab mixture distribution. The default is
TRUE.}

\item{sigma_sZero}{Each element of the signature matrix (S) is modeled by a
spike-and-slab mixture distribution. Sigma_sZero is the variance of the
spike normal distribution. The default is 0.01.}

\item{sigma_sNonZero}{Each element of the signature matrix (S) is modeled by
a spike-and-slab mixture distribution. Sigma_sNonZero is the variance of
the slab normal distribution. The default is 1.}

\item{p_beta}{p_beta is the prior probability of a pathway being activated
in individual test samples. The default is 0.01.}

\item{sigma_bZero}{Each element of the pathway activation matrix (A) is
modeled by a spike-and-slab mixture distribution. sigma_bZero is the
variance of the spike normal distribution. The default is 0.01.}

\item{sigma_bNonZero}{Each element of the pathway activation matrix (A) is
modeled by a spike-and-slab mixture distribution. sigma_bNonZero is the
variance of the slab normal distribution. The default is 1.}

\item{alpha_tau}{The shape parameter of the precision (inverse of the
variance) of a gene. The default is 1.}

\item{beta_tau}{The rate parameter of the precision (inverse of the
variance) of a gene. The default is 0.01.}

\item{Bg_zeroPrior}{Logicals. If TRUE, the prior distribution of
baseline/background level follows a normal distribution with mean zero. The
default is TRUE.}

\item{S_zeroPrior}{Logicals. If TRUE, the prior distribution of signature
follows a normal distribution with mean zero. The default is TRUE.}

\item{ECM}{Logicals. If TRUE, ECM algorithm, rather than Gibbs sampling, is
applied to approximate the model parameters. The default is FALSE.}

\item{progress_bar}{Display a progress bar for MCMC. Default is TRUE.}
}
\value{
\item{beta_mcmc}{The iter x K x J array of the pathway activation
level estimated in every iteration of MCMC.} \item{tau2_mcmc}{The iter x G
matrix of the precision of genes estimated in every iteration of MCMC}
\item{gamma_mcmc}{The iter x K x J array of probability of pathway being
activated estimated in every iteration of MCMC.} \item{kappa_mcmc}{The iter
x K x J array of pathway activation level (adjusted beta scaling between 0
and 1) estimated in every iteration of MCMC.)} \item{S_mcmc}{The iter x G x
K array of signature estimated in every iteration of MCMC.}
\item{Delta_mcmc}{The iter x G x K array of binary indicator of a gene being
significant estimated in every iteration of MCMC.}
}
\description{
The assign.mcmc function uses a Bayesian sparse factor analysis model to
estimate the adaptive baseline/background, adaptive pathway signature, and
pathway activation status of individual test (disease) samples.
}
\details{
The assign.mcmc function can be set as following major modes. The
combination of logical values of adaptive_B, adaptive_S and mixture_beta can
form different modes.

Mode A: adaptive_B = FALSE, adaptive_S = FALSE, mixture_beta = FALSE. This
is a regression mode without adaptation of baseline/background, signature,
and no shrinkage of the pathway activation level.

Mode B: adaptive_B = TRUE, adaptive_S = FALSE, mixture_beta = FALSE. This is
a regression mode with adaptation of baseline/background, but without
signature, and with no shrinkage of the pathway activation level.

Mode C: adaptive_B = TRUE, adaptive_S = FALSE, mixture_beta = TRUE. This is
a regression mode with adaptation of baseline/background, but without
signature, and with shrinkage of the pathway activation level when it is not
significantly activated.

Mode D: adaptive_B = TRUE, adaptive_S = TRUE, mixture_beta = TRUE. This is a
Bayesian factor analysis mode with adaptation of baseline/background,
adaptation signature, and with shrinkage of the pathway activation level.
}
\examples{

\dontshow{
data(trainingData1)
data(testData1)
data(geneList1)
trainingLabel1 <- list(control = list(bcat=1:10, e2f3=1:10, myc=1:10,
                                      ras=1:10, src=1:10),
                       bcat = 11:19, e2f3 = 20:28, myc= 29:38,
                       ras = 39:48, src = 49:55)

processed.data <- assign.preprocess(trainingData=trainingData1,
testData=testData1, trainingLabel=trainingLabel1, geneList=geneList1)
}
mcmc.chain <- assign.mcmc(Y=processed.data$testData_sub,
                          Bg = processed.data$B_vector,
                          X=processed.data$S_matrix,
                          Delta_prior_p = processed.data$Pi_matrix,
                          iter = 20, adaptive_B=TRUE, adaptive_S=FALSE,
                          mixture_beta=TRUE)

}
\author{
Ying Shen
}
