% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-class.R, R/ASICSResults-class.R,
%   R/AnalysisResults-class.R
\name{summary-methods}
\alias{summary-methods}
\alias{show,Spectra-method}
\alias{show.Spectra}
\alias{summary,Spectra-method}
\alias{summary.Spectra}
\alias{length,Spectra-method}
\alias{length.Spectra}
\alias{dim,Spectra-method}
\alias{dim.Spectra}
\alias{show,ASICSResults-method}
\alias{show.ASICSResults}
\alias{dim,ASICSResults-method}
\alias{show,AnalysisResults-method}
\alias{show.AnalysisResults}
\alias{summary,AnalysisResults-method}
\alias{summary.AnalysisResults}
\title{Summary methods}
\usage{
\S4method{show}{Spectra}(object)

\S4method{summary}{Spectra}(object)

\S4method{length}{Spectra}(x)

\S4method{dim}{Spectra}(x)

\S4method{show}{ASICSResults}(object)

\S4method{dim}{ASICSResults}(x)

\S4method{show}{AnalysisResults}(object)

\S4method{summary}{AnalysisResults}(object)
}
\arguments{
\item{object}{An object of class \linkS4class{Spectra},
\linkS4class{PureLibrary}, \linkS4class{ASICSResults} or
\linkS4class{AnalysisResults}.}

\item{x}{An object of class \linkS4class{Spectra},
\linkS4class{PureLibrary} or \linkS4class{ASICSResults}.}
}
\value{
A summary of the object, its length or its dimensions.
}
\description{
Methods available to summarize the various S4 objects of ASICS package.
}
\examples{
# Import data and create object
current_path <- file.path(system.file("extdata", package = "ASICS"),
                          "spectra_example.txt")
spectra_data <- read.table(current_path, header = TRUE, row.names = 1)
spectra_obj <- createSpectra(spectra_data)

# Summary
summary(spectra_obj)
# Length
length(spectra_obj)
# Dimensions
dim(spectra_obj)
}
