% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{elbow_method}
\alias{elbow_method}
\title{Runs elbow method}
\usage{
elbow_method(obj, mat, reps, python = FALSE, return_plot = FALSE)
}
\arguments{
\item{obj}{A "cacomp" object as outputted from `cacomp()`}

\item{mat}{A numeric matrix. For sequencing a count matrix, gene expression
values with genes in rows and samples/cells in columns.
Should contain row and column names.}

\item{reps}{Integer. Number of permutations to perform when choosing
"elbow_rule".}

\item{python}{A logical value indicating whether to use singular value
decomposition from the python package torch.
This implementation dramatically speeds up computation compared to `svd()`
in R.}

\item{return_plot}{TRUE/FALSE. Whether a plot should be returned when
choosing "elbow_rule".}
}
\value{
`elbow_method` (for `return_plot=TRUE`) returns a list with two elements:
"dims" contains the number of dimensions and "plot" a ggplot. if
`return_plot=TRUE` it just returns the number of picked dimensions.
}
\description{
Helper function for pick_dims() to run the elbow method.
}
\examples{

# Get example data from Seurat
library(SeuratObject)
set.seed(2358)
cnts <- as.matrix(SeuratObject::LayerData(pbmc_small,
                                          assay = "RNA",
                                          layer = "data"))
# Run correspondence analysis.
ca <- cacomp(obj = cnts)

# pick dimensions with the elbow rule. Returns list.
pd <- pick_dims(obj = ca,
                mat = cnts,
                method = "elbow_rule",
                return_plot = TRUE,
                reps = 10)
pd$plot
ca_sub <- subset_dims(ca, dims = pd$dims)

}
\references{
Ciampi, Antonio, González Marcos, Ana and Castejón Limas, Manuel. \cr
Correspondence analysis and 2-way clustering. (2005), SORT 29(1).
}
