% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apl.R
\name{apl_coords}
\alias{apl_coords}
\title{Calculate Association Plot coordinates}
\usage{
apl_coords(caobj, group, calc_rows = TRUE, calc_cols = TRUE)
}
\arguments{
\item{caobj}{A "cacomp" object with principal row coordinates and
standardized column coordinates calculated.}

\item{group}{Numeric/Character. Vector of indices or column names of
the columns to calculate centroid/x-axis direction.}

\item{calc_rows}{TRUE/FALSE. Whether apl row coordinates should
be calculated. Default TRUE.}

\item{calc_cols}{TRUE/FALSE. Whether apl column coordinates should
be calculated. Default TRUE.}
}
\value{
Returns input "cacomp" object and adds components "apl_rows" and/or
"apl_cols" for row and column coordinates.
In "group" the indices of the columns used to calculate the
centroid are saved.
}
\description{
Calculates the Association Plot coordinates for either the rows,
columns or both (default).
}
\details{
Coordinates (x,y) of row vector \eqn{\vec{r}} are defined as
\deqn{x(\vec{r}) := \left|\vec{r}\right|\cos(\phi(\vec{r}))}
\deqn{y(\vec{r}) := \left|\vec{r}\right|\sin(\phi(\vec{r}))}
The x-direction is determined by calculating the centroid of the columns
selected with the indices in "group".
}
\examples{
set.seed(1234)
# Simulate scRNAseq data
cnts <- data.frame(cell_1 = rpois(10, 5),
                   cell_2 = rpois(10, 10),
                   cell_3 = rpois(10, 20),
                   cell_4 = rpois(10, 20))
rownames(cnts) <- paste0("gene_", 1:10)
cnts <- as.matrix(cnts)

# Run correspondence analysis
ca <- cacomp(obj = cnts, princ_coords = 3, dims = 3)
# Calculate APL coordinates
ca <- apl_coords(ca, group = 3:4)
}
\references{
Association Plots: Visualizing associations in high-dimensional
correspondence analysis biplots
Elzbieta Gralinska, Martin Vingron
bioRxiv 2020.10.23.352096; doi: https://doi.org/10.1101/2020.10.23.352096
}
