% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOUNTAIN.R
\name{moduleIdentificationGPFixSSMultilayer}
\alias{moduleIdentificationGPFixSSMultilayer}
\title{Module Identification for multi-layer network}
\usage{
moduleIdentificationGPFixSSMultilayer(W, listz, x0, a = 0.5, lambda = 1,
  maxiter = 1000)
}
\arguments{
\item{W}{edge score matrix of the network, n x n matrix}

\item{listz}{a list of node score vectors, each layer has a n-length vector}

\item{x0}{initial solution, n-length vector}

\item{a}{parameter in elastic net the same as in \code{\link{EuclideanProjectionENNORM}}}

\item{lambda}{parameter in objective, coefficient of node score of other layers}

\item{maxiter}{maximal interation of whole procedure}
}
\value{
a list containing objective values and solution
}
\description{
Algorithm for Module Identification on multi-layer network sharing the same set of genes
}
\examples{
n = 100
k = 20
L = 5
theta = 0.5
cpl <- multilayernetworkSimulation(n,k,theta,L)
listz <- list()
for (i in 1:L){
listz[[i]] <- cpl[[i+2]]
}
moduleid <- cpl[[2]]
## use default parameters here
x <- moduleIdentificationGPFixSSMultilayer(cpl[[1]],listz,rep(1/n,n))
predictedid <- which(x[[2]]!=0)
recall <- length(intersect(predictedid,moduleid))/length(moduleid)
precise <- length(intersect(predictedid,moduleid))/length(predictedid)
Fscore <- (2*precise*recall/(precise+recall))
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\references{
AMOUNTAIN
}
\seealso{
\code{\link{moduleIdentificationGPFixSSMultilayer}}
}
\keyword{identification,}
\keyword{module}
\keyword{multi-layer}

